/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shindig.spi;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import java.util.Date;
import java.util.UUID;

import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.social.opensocial.oauth.OAuthEntry;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import nl.surfnet.coin.mock.AbstractMockHttpServerTest;

/**
 * {@link Test} for {@link OAuthEntryServiceImpl}
 * 
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = {
    "classpath:coin-shindig-hsqldb-properties-context.xml",
    "classpath:coin-shindig-context.xml",
    "classpath:coin-shared-context.xml" })
@TransactionConfiguration(transactionManager = "transactionManager", defaultRollback = true)
@Transactional
public class OAuthEntryServiceImplTest extends AbstractMockHttpServerTest {

  @Autowired
  private OAuthEntryService oAuthEntryService;

  @Autowired
  private SessionFactory sessionFactory;
  
  private final static String TOKEN = UUID.randomUUID().toString();

  @Before
  public void setupDbContent() throws Exception {
    OAuthEntry entry = new OAuthEntry();
    entry.setAppId("appId");
    entry.setAuthorized(false);
    entry.setCallbackToken("callbackToken");
    entry.setCallbackTokenAttempts(0);
    entry.setCallbackUrl("callbackUrl");
    entry.setConsumerKey("consumerKey");
    entry.setContainer("container");
    entry.setDomain("domain");
    entry.setIssueTime(new Date());
    entry.setOauthVersion("1.0");
    entry.setToken(TOKEN);
    entry.setType(OAuthEntry.Type.REQUEST);

    oAuthEntryService.saveOAuthEntry(entry);
    flushSession();
  }

  @After
  public void flushSession() {
    // flushing forces the actual sql to be executed
    sessionFactory.getCurrentSession().flush();
  }

  @Test
  public void testOAuthEntry() {
    OAuthEntry entry = oAuthEntryService.getOAuthEntry(TOKEN);
    assertEquals(TOKEN, entry.getToken());
  }
  
  @Test
  public void testDeleteOAuthEntry() throws BlobCrypterException {
    oAuthEntryService.deleteOAuthEntry(TOKEN);
    flushSession();
    
    OAuthEntry entry = oAuthEntryService.getOAuthEntry(TOKEN);
    
    assertNull(entry);
  }

}
