/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shindig.spi;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.mock;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.apache.shindig.social.opensocial.spi.UserId.Type;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * {@link Test} for {@link PersonServiceImpl} that requires an EngineBlock
 * endpoint
 * 
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = {
    "classpath:coin-shindig-properties-context.xml",
    "classpath:coin-shindig-context.xml",
    "classpath:coin-shared-context.xml" })
public class PersonServiceImplTestIntegration {

  @Autowired
  private PersonService personService;

  /**
   * Test method for
   * {@link nl.surfnet.coin.shindig.spi.PersonServiceImpl#getPerson(org.apache.shindig.social.opensocial.spi.UserId, java.util.Set, org.apache.shindig.auth.SecurityToken)}
   * .
   */
  @Test
  public void testGetPerson() throws Exception {
    UserId id = new UserId(Type.userId, "urn:collab:person:surfnet.nl:hansz");
    SecurityToken token = mock(SecurityToken.class);
    Person person = personService.getPerson(id, null, token).get();
    assertEquals("Hans Zandbelt", person.getDisplayName());
    assertEquals("Hans.Zandbelt@surfnet.nl", person.getEmails().iterator()
        .next().getValue());
  }

  @Test
  public void testGetPersons() throws Exception {
    // https://gadgets.dev.coin.surf.net/social/rest/people/urn:collab:person:surfnet.nl:hansz/test:3tu_identity_management?fields=all
    UserId id = new UserId(Type.userId, "urn:collab:person:surfnet.nl:hansz");
    SecurityToken token = mock(SecurityToken.class);
    GroupId groupId = new GroupId(
        org.apache.shindig.social.opensocial.spi.GroupId.Type.groupId,
        "test:3tu_identity_management");
    Set<UserId> ids = new HashSet<UserId>();
    ids.add(id);
    List<Person> persons = personService.getPeople(ids, groupId, null, null,
        token).get().getEntry();
    assertTrue(persons.size() > 2);
  }

}
