/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.oauth;

import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import nl.surfnet.coin.mock.AbstractMockHttpServerTest;
import nl.surfnet.coin.shared.service.ErrorMessageMailer;
import nl.surfnet.coin.shindig.oauth.CoinOAuthDataStore;
import nl.surfnet.coin.shindig.protocol.ContextEnvironment;
import nl.surfnet.coin.shindig.protocol.HttpClientProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class CoinOAuthDataStoreTest
extends AbstractMockHttpServerTest {
    private CoinOAuthDataStore dataStore;

    @Before
    public void setup() {
        ErrorMessageMailer errorMessageMailer = new ErrorMessageMailer();
        this.dataStore = new CoinOAuthDataStore();
        this.dataStore.setErrorMessageMailer(errorMessageMailer);
        ContextEnvironment environment = new ContextEnvironment();
        environment.setBaseSocialApiUrl("http://localhost:8088");
        this.dataStore.setEnvironment(environment);
        this.dataStore.setHttpClientProvider(new HttpClientProvider());
    }

    @Test
    public void testGetConsumer() throws Exception {
        this.setResponseResource((Resource)new ClassPathResource("json/mock-oauth-secret.json"));
        OAuthConsumer consumer = this.dataStore.getConsumer("testkey");
        Assert.assertEquals((Object)"testsecret", (Object)consumer.consumerSecret);
    }

    @Test
    public void testGetEmptyConsumer() throws Exception {
        this.setResponseResource((Resource)new ClassPathResource("json/mock-oauth-empty-secret.json"));
        try {
            this.dataStore.getConsumer("testkey");
            Assert.fail((String)"Expected oauthException");
        }
        catch (OAuthException oAuthException) {
            // empty catch block
        }
    }
}

