/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.oauth;

import nl.surfnet.coin.mock.AbstractMockHttpServerTest;
import nl.surfnet.coin.shared.service.ErrorMessageMailer;
import nl.surfnet.coin.shared.service.MockJavaMailSender;
import nl.surfnet.coin.shindig.oauth.CoinOAuthStore;
import nl.surfnet.coin.shindig.oauth.CoinOAuthStoreProvider;
import nl.surfnet.coin.shindig.spi.TokenInfoService;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSender;

public class CoinOAuthStoreTest
extends AbstractMockHttpServerTest {
    private CoinOAuthStore store;

    @Test
    public void testGetConsumerKeyAndSecretSecurityTokenStringOAuthServiceProvider() throws Exception {
        CoinOAuthStoreProvider provider = new CoinOAuthStoreProvider(null, "http://localhost:8088", "keys/oauthkey.pem", "coin-shindig-key"){

            protected TokenInfoService getTokenInfoService() {
                return (TokenInfoService)Mockito.mock(TokenInfoService.class);
            }

            protected ErrorMessageMailer getErrorMessageMailer() {
                ErrorMessageMailer errorMessageMailer = new ErrorMessageMailer();
                errorMessageMailer.setMailSender((JavaMailSender)new MockJavaMailSender());
                return errorMessageMailer;
            }
        };
        this.store = (CoinOAuthStore)provider.get();
        this.setResponseResource((Resource)new ClassPathResource("json/mock-oauth-three-legged.json"));
        OAuthStore.ConsumerInfo consumer = this.store.getConsumerKeyAndSecret((SecurityToken)new AnonymousSecurityToken("container", 1L, "gadget.xml", Long.valueOf(1L)), "google", null);
        Assert.assertEquals((Object)"gadgetSecret", (Object)consumer.getConsumer().consumerSecret);
        this.setResponseResource((Resource)new ClassPathResource("json/mock-oauth-three-legged-empty.json"));
        try {
            consumer = this.store.getConsumerKeyAndSecret((SecurityToken)new AnonymousSecurityToken("container", 1L, "gadget.xml", Long.valueOf(1L)), "google", null);
            Assert.fail((String)"Expected GadgetException");
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }
}

