/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import nl.surfnet.coin.mock.AbstractMockHttpServerTest;
import nl.surfnet.coin.shindig.spi.CoinActivityService;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.core.model.GroupImpl;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Group;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.stubbing.Answer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:coin-shindig-hsqldb-properties-context.xml", "classpath:coin-shindig-context.xml", "classpath:coin-shared-context.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class ActivityServiceImplTest
extends AbstractMockHttpServerTest {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private CoinActivityService coinActivityService;
    @Autowired
    private SessionFactory sessionFactory;
    private String appId1 = "testAppId";
    private String appId2 = "unknown";
    private UserId user1 = new UserId(UserId.Type.userId, "user1");
    private GroupId groupId = new GroupId(GroupId.Type.groupId, "testGroupId");
    private String activityId;

    @Before
    public void setupDbContent() throws Exception {
        ActivityImpl activity = new ActivityImpl();
        activity.setAppId(this.appId1);
        activity.setBody("body");
        this.setResponseResource((Resource)new ClassPathResource("json/mock-single-person.json"));
        this.activityService.createActivity(this.user1, new GroupId(GroupId.Type.groupId, this.groupId.getGroupId()), this.appId1, null, (Activity)activity, this.getMockToken(this.user1));
        this.activityId = activity.getId();
        activity = new ActivityImpl();
        activity.setAppId(this.appId2);
        activity.setBody("body2");
        this.activityService.createActivity(this.user1, new GroupId(GroupId.Type.groupId, this.groupId.getGroupId()), this.appId2, null, (Activity)activity, this.getMockToken(this.user1));
        this.sessionFactory.getCurrentSession().flush();
    }

    @After
    public void flushSession() {
        this.sessionFactory.getCurrentSession().flush();
    }

    @Test
    public void testGetActivity() throws Exception {
        Activity activity = (Activity)this.activityService.getActivity(this.user1, null, null, null, this.activityId, this.getMockToken(this.user1)).get();
        Assert.assertEquals((Object)"body", (Object)activity.getBody());
    }

    @Test
    public void testGetActivitiesByAppId() throws Exception {
        List activities = ((RestfulCollection)this.activityService.getActivities(new HashSet(), this.groupId, this.appId2, null, null, this.getMockToken(this.user1)).get()).getEntry();
        Assert.assertEquals((long)1L, (long)activities.size());
        activities = ((RestfulCollection)this.activityService.getActivities(Collections.singleton(this.user1), null, null, null, null, null).get()).getEntry();
        Assert.assertEquals((long)0L, (long)activities.size());
    }

    @Test
    public void testFindActivityByGroupId() throws Exception {
        GroupImpl group = new GroupImpl();
        group.setId(this.groupId);
        List activities = this.coinActivityService.findActivityByGroups((Group)group, 1, 1);
        Assert.assertEquals((long)1L, (long)activities.size());
    }

    private SecurityToken getMockToken(UserId id) {
        SecurityToken mock = (SecurityToken)Mockito.mock(SecurityToken.class, (Answer)new Returns((Object)id.getUserId()));
        return mock;
    }
}

