/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:coin-shindig-hsqldb-properties-context.xml", "classpath:coin-shindig-context.xml", "classpath:coin-shared-context.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class AppDataServiceImplTest {
    @Autowired
    private AppDataService appDataService;
    @Autowired
    private SessionFactory sessionFactory;
    private String appId1 = "app1";
    private String appId2 = "app2";
    private String personId1 = "personId1";
    private String personId2 = "personId2";

    @Before
    public void setupDbContent() {
        this.createPersonAppData(this.appId1, this.personId1, "key1", "value1");
        this.createPersonAppData(this.appId1, this.personId2, "key2", "value2");
        this.createPersonAppData(this.appId2, this.personId2, "key3", "value3");
    }

    private void createPersonAppData(String appId, String personId, String key, String value) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(key, value);
        this.appDataService.updatePersonData(new UserId(UserId.Type.userId, personId), null, appId, null, data, null);
        this.sessionFactory.getCurrentSession().flush();
    }

    @After
    public void flushSession() {
        this.sessionFactory.getCurrentSession().flush();
    }

    @Test
    public void testGetAppData() throws ProtocolException, InterruptedException, ExecutionException {
        DataCollection dataCollection = (DataCollection)this.appDataService.getPersonData(Collections.singleton(new UserId(UserId.Type.userId, this.personId1)), null, this.appId1, null, null).get();
        Map entry = dataCollection.getEntry();
        Assert.assertEquals((long)1L, (long)entry.size());
        String value = (String)((Map)entry.get(this.appId1)).get("key1");
        Assert.assertEquals((Object)value, (Object)"value1");
        dataCollection = (DataCollection)this.appDataService.getPersonData(Collections.singleton(new UserId(UserId.Type.userId, this.personId2)), null, null, null, null).get();
        entry = dataCollection.getEntry();
        Assert.assertEquals((long)2L, (long)entry.size());
    }
}

