/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import nl.surfnet.coin.shindig.model.PersistentUrl;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.model.SortOrder;
import org.apache.shindig.social.core.model.MessageCollectionImpl;
import org.apache.shindig.social.core.model.MessageImpl;
import org.apache.shindig.social.opensocial.model.Message;
import org.apache.shindig.social.opensocial.model.MessageCollection;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.MessageService;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:coin-shindig-hsqldb-properties-context.xml", "classpath:coin-shindig-context.xml", "classpath:coin-shared-context.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class MessageServiceImplTest {
    @Autowired
    private MessageService messageService;
    @Autowired
    private SessionFactory sessionFactory;
    private String group1 = "group1";
    private String messageId;
    private String messageCollectionId;

    @Before
    public void setupDbContent() {
        MessageCollectionImpl msgColl = new MessageCollectionImpl();
        msgColl.setTitle(this.group1);
        PersistentUrl url = new PersistentUrl();
        url.setLinkText("linkText");
        url.setValue("value");
        msgColl.setUrls(Collections.singletonList(url));
        this.messageService.createMessageCollection(null, (MessageCollection)msgColl, null);
        this.messageCollectionId = msgColl.getId();
        MessageImpl message = new MessageImpl();
        message.setStatus(Message.Status.NEW);
        message.setBody("body");
        message.setCollectionIds(Collections.singletonList(msgColl.getId()));
        this.messageService.createMessage(null, null, null, (Message)message, null);
        this.messageId = message.getId();
        this.sessionFactory.getCurrentSession().flush();
    }

    @After
    public void flushSession() {
        this.sessionFactory.getCurrentSession().flush();
    }

    @Test
    public void testGetMessage() throws InterruptedException, ExecutionException {
        CollectionOptions options = new CollectionOptions();
        options.setSortBy("timeSent");
        options.setSortOrder(SortOrder.ascending);
        options.setFirst(0);
        options.setMax(20);
        Future result = this.messageService.getMessages(null, this.messageCollectionId, null, null, options, null);
        List messages = ((RestfulCollection)result.get()).getEntry();
        Assert.assertEquals((long)1L, (long)messages.size());
        result = this.messageService.getMessages(null, null, null, Collections.singletonList(this.messageId), options, null);
        messages = ((RestfulCollection)result.get()).getEntry();
        Assert.assertEquals((long)1L, (long)messages.size());
    }

    @Test
    public void testGetMessageCollection() throws InterruptedException, ExecutionException {
        Future result = this.messageService.getMessageCollections(null, null, null, null);
        List messages = ((RestfulCollection)result.get()).getEntry();
        Assert.assertEquals((long)1L, (long)messages.size());
    }

    @Test
    public void testCreateMessageCollection() throws InterruptedException, ExecutionException {
        MessageCollectionImpl mc = new MessageCollectionImpl();
        mc.setTitle(this.group1);
        mc = (MessageCollection)this.messageService.createMessageCollection(null, (MessageCollection)mc, null).get();
        Assert.assertEquals((Object)this.messageCollectionId, (Object)mc.getId());
    }
}

