/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import nl.surfnet.coin.mock.AbstractMockHttpServerTest;
import nl.surfnet.coin.shared.log.ApiCallLogService;
import nl.surfnet.coin.shared.service.ErrorMessageMailer;
import nl.surfnet.coin.shindig.protocol.ContextEnvironment;
import nl.surfnet.coin.shindig.protocol.HttpClientProvider;
import nl.surfnet.coin.shindig.spi.ApiCallLogServiceMock;
import nl.surfnet.coin.shindig.spi.GroupServiceImpl;
import nl.surfnet.coin.shindig.spi.OpenSocialValidator;
import nl.surfnet.coin.shindig.spi.PersonServiceImpl;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.core.oauth.OAuthSecurityToken;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.Organization;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.GroupService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class PersonServiceImplTest
extends AbstractMockHttpServerTest {
    private PersonServiceImpl personService = new PersonServiceImpl();

    public PersonServiceImplTest() {
        ContextEnvironment environment = new ContextEnvironment();
        environment.setBaseSocialApiUrl("http://localhost:8088/social/person");
        this.personService.setEnvironment(environment);
        this.personService.setHttpClientProvider(new HttpClientProvider());
        this.personService.setOpenSocialId(new OpenSocialValidator());
        ApiCallLogServiceMock logService = new ApiCallLogServiceMock();
        this.personService.setLogService((ApiCallLogService)logService);
        ErrorMessageMailer errorMessageMailer = new ErrorMessageMailer();
        this.personService.setErrorMessageMailer(errorMessageMailer);
        GroupServiceImpl groupService = new GroupServiceImpl();
        groupService.setEnvironment(environment);
        groupService.setErrorMessageMailer(errorMessageMailer);
        groupService.setHttpClientProvider(new HttpClientProvider());
        groupService.setLogService((ApiCallLogService)logService);
        this.personService.setGroupService((GroupService)groupService);
    }

    @Test
    public void testGetPerson() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "urn:collab:person:surfnet.nl:hansz");
        SecurityToken token = this.getMockToken(id);
        this.setResponseResource((Resource)new ClassPathResource("json/mock-single-person.json"));
        Person person = (Person)this.personService.getPerson(id, null, token).get();
        Assert.assertEquals((Object)"Hans Zandbelt", (Object)person.getDisplayName());
        Assert.assertEquals((Object)"Hans.Zandbelt@surfnet.nl", (Object)((ListField)person.getEmails().get(0)).getValue());
        this.setResponseResource((Resource)new ClassPathResource("json/mock-empty-person.json"));
        person = (Person)this.personService.getPerson(id, null, token).get();
        Assert.assertNull((Object)person);
    }

    private SecurityToken getMockToken(UserId id) {
        OAuthSecurityToken mock = new OAuthSecurityToken(id.getUserId(), "appUrl", "appId", "domain", "container", Long.valueOf(0L), "virtualOrganization", "serviceProviderEntityId");
        return mock;
    }

    @Test
    public void testGetPeople() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "urn:collab:person:surfnet.nl:hansz");
        SecurityToken token = this.getMockToken(id);
        this.setResponseResource((Resource)new ClassPathResource("json/mock-multiple-persons.json"));
        HashSet<UserId> userIds = new HashSet<UserId>();
        userIds.add(id);
        Future people = this.personService.getPeople(userIds, new GroupId(GroupId.Type.groupId, "testGroup"), null, null, token);
        List persons = ((RestfulCollection)people.get()).getEntry();
        Assert.assertEquals((long)2L, (long)persons.size());
    }

    @Test
    public void testGetMultiplePeople() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "urn:collab:person:surfnet.nl:hansz");
        SecurityToken token = this.getMockToken(id);
        this.setResponseResource((Resource)new ClassPathResource("json/mock-multiple-persons.json"));
        HashSet<UserId> userIds = new HashSet<UserId>();
        userIds.add(new UserId(UserId.Type.userId, "1"));
        userIds.add(new UserId(UserId.Type.userId, "2"));
        Future people = this.personService.getPeople(userIds, null, null, null, token);
        List persons = ((RestfulCollection)people.get()).getEntry();
        Assert.assertEquals((long)2L, (long)persons.size());
    }

    @Test
    public void testGetMultiplePeopleFromGroup() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "urn:collab:person:surfnet.nl:hansz");
        SecurityToken token = this.getMockToken(id);
        this.setResponseResource((Resource)new ClassPathResource("json/mock-tu-persons.json"));
        HashSet<UserId> userIds = new HashSet<UserId>();
        userIds.add(id);
        GroupId groupId = new GroupId(GroupId.Type.groupId, "test");
        Future people = this.personService.getPeople(userIds, groupId, null, null, token);
        List persons = ((RestfulCollection)people.get()).getEntry();
        Assert.assertEquals((long)4L, (long)persons.size());
    }

    @Test
    public void testGetPeopleFromArrayInArray() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "urn:collab:person:surfnet.nl:hansz");
        SecurityToken token = this.getMockToken(id);
        this.setResponseResource((Resource)new ClassPathResource("json/array-in-array-hz.json"));
        HashSet<UserId> userIds = new HashSet<UserId>();
        userIds.add(id);
        Future people = this.personService.getPeople(userIds, null, null, null, token);
        List persons = ((RestfulCollection)people.get()).getEntry();
        Assert.assertEquals((long)1L, (long)persons.size());
    }

    @Test
    public void testGetOrganisationFromPerson() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "whatever");
        SecurityToken token = this.getMockToken(id);
        this.setResponseResource((Resource)new ClassPathResource("json/mock-single-person-with-organization.json"));
        Person person = (Person)this.personService.getPerson(id, null, token).get();
        List organizations = person.getOrganizations();
        Assert.assertEquals((long)1L, (long)organizations.size());
        Organization organization = (Organization)organizations.get(0);
        String name = organization.getName();
        Assert.assertEquals((Object)name, (Object)"test.surfguest.nl");
    }

    @Test
    public void testSecurityCheck() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "secret-person");
        OAuthSecurityToken token = new OAuthSecurityToken("onBehalfOf", "appUrl", "appId", "domain", "container", Long.valueOf(Long.MAX_VALUE), "authMode", null, null);
        this.setResponseResource(new Resource[]{new ClassPathResource("json/mock-multiple-teams.json"), new ClassPathResource("json/mock-multiple-teams-for-identity-check.json"), new ClassPathResource("json/mock-single-person-with-organization.json")});
        try {
            this.personService.getPerson(id, null, (SecurityToken)token).get();
            Assert.fail((String)"IllegalArgumentException because of security breach ");
        }
        catch (RuntimeException e) {
            String message = e.getCause().getMessage();
            Assert.assertTrue((boolean)message.contains("not granted"));
        }
    }

    @Test
    public void testSecurityCheckHappyFlow() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "secret-person");
        OAuthSecurityToken token = new OAuthSecurityToken("onBehalfOf", "appUrl", "appId", "domain", "container", Long.valueOf(Long.MAX_VALUE), "authMode", null, null);
        this.setResponseResource(new Resource[]{new ClassPathResource("json/mock-multiple-teams.json"), new ClassPathResource("json/mock-multiple-teams.json"), new ClassPathResource("json/mock-single-person-with-organization.json")});
        this.personService.getPerson(id, null, (SecurityToken)token).get();
    }

    @Test
    public void testGetTeamMebersSecurityException() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "urn:collab:person:surfnet.nl:hansz");
        OAuthSecurityToken token = new OAuthSecurityToken("onBehalfOf", "appUrl", "appId", "domain", "container", Long.valueOf(Long.MAX_VALUE), "authMode", null, null);
        this.setResponseResource((Resource)new ClassPathResource("json/mock-multiple-persons.json"));
        HashSet<UserId> userIds = new HashSet<UserId>();
        userIds.add(id);
        try {
            this.personService.getPeople(userIds, new GroupId(GroupId.Type.groupId, "testGroup"), null, null, (SecurityToken)token);
            Assert.fail((String)"Expected security breach exception");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("not granted"));
        }
    }
}

