/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.util.HashSet;
import java.util.List;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:coin-shindig-properties-context.xml", "classpath:coin-shindig-context.xml", "classpath:coin-shared-context.xml"})
public class PersonServiceImplTestIntegration {
    @Autowired
    private PersonService personService;

    @Test
    public void testGetPerson() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "urn:collab:person:surfnet.nl:hansz");
        SecurityToken token = (SecurityToken)Mockito.mock(SecurityToken.class);
        Person person = (Person)this.personService.getPerson(id, null, token).get();
        Assert.assertEquals((Object)"Hans Zandbelt", (Object)person.getDisplayName());
        Assert.assertEquals((Object)"Hans.Zandbelt@surfnet.nl", (Object)((ListField)person.getEmails().iterator().next()).getValue());
    }

    @Test
    public void testGetPersons() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "urn:collab:person:surfnet.nl:hansz");
        SecurityToken token = (SecurityToken)Mockito.mock(SecurityToken.class);
        GroupId groupId = new GroupId(GroupId.Type.groupId, "test:3tu_identity_management");
        HashSet<UserId> ids = new HashSet<UserId>();
        ids.add(id);
        List persons = ((RestfulCollection)this.personService.getPeople(ids, groupId, null, null, token).get()).getEntry();
        Assert.assertTrue((persons.size() > 2 ? 1 : 0) != 0);
    }
}

