/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import nl.surfnet.coin.mock.AbstractMockHttpServerTest;
import nl.surfnet.coin.shindig.oauth.CoinOAuthTokenInfo;
import nl.surfnet.coin.shindig.spi.TokenInfoService;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:coin-shindig-hsqldb-properties-context.xml", "classpath:coin-shindig-context.xml", "classpath:coin-shared-context.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class TokenInfoServiceImplTest
extends AbstractMockHttpServerTest {
    @Autowired
    private TokenInfoService tokenInfoService;
    @Autowired
    private SessionFactory sessionFactory;

    @Before
    public void setupDbContent() throws Exception {
        CoinOAuthTokenInfo info = new CoinOAuthTokenInfo();
        info.setAccessToken("accessToken");
        info.setAppUrl("appUrl");
        info.setModuleId("moduleId");
        info.setServiceName("serviceName");
        info.setSessionHandle("sessionHandle");
        info.setTokenName("tokenName");
        info.setTokenSecret("tokenSecret");
        info.setUserId("userId");
        this.tokenInfoService.saveCoinOAuthTokenInfo(info);
        this.flushSession();
    }

    @After
    public void flushSession() {
        this.sessionFactory.getCurrentSession().flush();
    }

    @Test
    public void testCoinOAuthTokenInfo() {
        CoinOAuthTokenInfo info = this.tokenInfoService.getCoinOAuthTokenInfo("userId", "appUrl", "moduleId", "tokenName", "serviceName");
        Assert.assertNotNull((Object)info.getId());
    }

    @Test
    public void testDeleteCoinOAuthTokenInfo() throws BlobCrypterException {
        this.tokenInfoService.deleteCoinOAuthTokenInfo("userId", "appUrl", "moduleId", "tokenName", "serviceName");
        this.flushSession();
        CoinOAuthTokenInfo info = this.tokenInfoService.getCoinOAuthTokenInfo("userId", "appUrl", "moduleId", "tokenName", "serviceName");
        Assert.assertNull((Object)info);
    }
}

