/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.protocol;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.springframework.stereotype.Component;

@Component(value="httpClientProvider")
public class HttpClientProvider {
    private DefaultHttpClient httpClient;

    public HttpClientProvider() {
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in configuration for httpClient", e);
        }
    }

    private void init() throws Exception {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        })));
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager connManager = new ThreadSafeClientConnManager(schemeRegistry);
        connManager.setMaxTotal(50);
        connManager.setDefaultMaxPerRoute(50);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)connManager);
    }

    public DefaultHttpClient getHttpClient() {
        return this.httpClient;
    }
}

