/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.shiro;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.surfnet.coin.shindig.protocol.ContextEnvironment;
import nl.surfnet.coin.shindig.spi.CoinGuiceModule;
import nl.surfnet.coin.shindig.spi.OAuthEntryService;
import org.apache.shindig.social.opensocial.oauth.OAuthEntry;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.SavedRequest;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CoinAuthenticationFilter
extends AuthenticatingFilter {
    public static final String DEFAULT_ERROR_KEY_ATTRIBUTE_NAME = "shiroLoginFailure";
    private static final String PASSWORD = "password";
    private String failureKeyAttribute = "shiroLoginFailure";
    private ContextEnvironment environment;
    private static final Logger logger = LoggerFactory.getLogger(FormAuthenticationFilter.class);

    public CoinAuthenticationFilter() {
        this.setLoginUrl("/login.jsp");
    }

    public void setLoginUrl(String loginUrl) {
        String previous = this.getLoginUrl();
        if (previous != null) {
            this.appliedPaths.remove(previous);
        }
        super.setLoginUrl(loginUrl);
        if (logger.isDebugEnabled()) {
            logger.debug("Adding login url to applied paths.");
        }
        this.appliedPaths.put(this.getLoginUrl(), null);
    }

    public String getFailureKeyAttribute() {
        return this.failureKeyAttribute;
    }

    public void setFailureKeyAttribute(String failureKeyAttribute) {
        this.failureKeyAttribute = failureKeyAttribute;
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        String remoteUser = this.getRemoteUser(request);
        if (!StringUtils.hasText((String)remoteUser)) {
            return null;
        }
        return this.createToken(remoteUser, PASSWORD, request, response);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response)) {
            if (this.isLoginSubmission(request, response)) {
                String remoteUser = this.getRemoteUser(request);
                if (!StringUtils.hasText((String)remoteUser)) {
                    this.redirectUserToShibboleth(request, response);
                    return false;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Login submission detected.  Attempting to execute login.");
                }
                return this.executeLogin(request, response);
            }
            if (logger.isDebugEnabled()) {
                logger.trace("Login page view.");
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Attempting to access a path which requires authentication.  Forwarding to the Authentication url [" + this.getLoginUrl() + "]");
        }
        this.saveRequestAndRedirectToLogin(request, response);
        return false;
    }

    private void redirectUserToShibboleth(ServletRequest request, ServletResponse response) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        ContextEnvironment environment = this.getEnvironment();
        String shindigHost = environment.getShindigBaseUrl();
        String shibLoginUrlSuffix = environment.getShibbolethAuthenticationUrlSuffix();
        String target = URLEncoder.encode(shindigHost + "login.jsp?login=true", "UTF-8");
        String virtualOrganization = this.getVirtualOrganization(request);
        String entityID = "";
        if (StringUtils.hasText((String)virtualOrganization)) {
            entityID = "&entityID=" + URLEncoder.encode(this.getEnvironment().getVoMetadataPrefix() + virtualOrganization, "UTF-8");
        }
        String location = shindigHost + shibLoginUrlSuffix + "?target=" + target + entityID;
        httpResponse.sendRedirect(location);
    }

    private String getVirtualOrganization(ServletRequest request) {
        int indexOf;
        String query;
        SavedRequest savedRequest;
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpSession session = servletRequest.getSession(false);
        String virtualOrganization = null;
        if (session != null && (savedRequest = (SavedRequest)session.getAttribute("shiroSavedRequest")) != null && (query = savedRequest.getQueryString()) != null && (indexOf = query.indexOf("oauth_token")) > -1) {
            int endIndex = query.indexOf("&", indexOf);
            endIndex = endIndex < 0 ? query.length() : endIndex;
            String token = query.substring(indexOf + "oauth_token=".length(), endIndex);
            OAuthEntryService entryService = (OAuthEntryService)CoinGuiceModule.getContext().getBean("oAuthEntryService");
            OAuthEntry oAuthEntry = entryService.getOAuthEntry(token);
            if (oAuthEntry != null) {
                virtualOrganization = oAuthEntry.getVirtualOrganization();
            }
        }
        return virtualOrganization;
    }

    private ContextEnvironment getEnvironment() {
        if (this.environment == null) {
            this.environment = (ContextEnvironment)CoinGuiceModule.getContext().getBean("environment");
        }
        return this.environment;
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        this.issueSuccessRedirect(request, response);
        return false;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        this.setFailureAttribute(request, e);
        return true;
    }

    protected boolean isLoginSubmission(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && WebUtils.toHttp((ServletRequest)request).getMethod().equalsIgnoreCase("POST");
    }

    protected void setFailureAttribute(ServletRequest request, AuthenticationException ae) {
        String className = ae.getClass().getName();
        request.setAttribute(this.getFailureKeyAttribute(), (Object)className);
    }

    protected String getRemoteUser(ServletRequest request) {
        String shibbolethDummyUser = this.getEnvironment().getShibbolethDummyUser();
        if (StringUtils.hasText((String)shibbolethDummyUser)) {
            return shibbolethDummyUser;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        return httpRequest.getHeader("REMOTE_USER");
    }
}

