/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import nl.surfnet.coin.shared.domain.ErrorMail;
import nl.surfnet.coin.shared.service.ErrorMessageMailer;
import nl.surfnet.coin.shindig.protocol.ContextEnvironment;
import nl.surfnet.coin.shindig.spi.CoinActivityService;
import nl.surfnet.coin.shindig.spi.OpenSocialValidator;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Group;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="activityService")
@Transactional
public class ActivityServiceImpl
implements ActivityService,
CoinActivityService {
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private OpenSocialValidator openSocialValidator;
    @Autowired
    private PersonService personService;
    @Autowired
    private ErrorMessageMailer errorMessageMailer;
    @Autowired
    private ContextEnvironment environment;
    private static final String ERROR_MAILER_TEMPLATE = "exception_shindig_plain.txt";
    private static final String ACTIVITY = ActivityImpl.class.getName();

    @Transactional
    public Future<Void> createActivity(UserId userId, GroupId groupId, String appId, Set<String> fields, Activity activity, SecurityToken token) throws ProtocolException {
        this.openSocialValidator.invariant(userId, groupId);
        if (!StringUtils.hasText((String)activity.getAppId())) {
            activity.setAppId(appId);
        }
        activity.setUserId(this.getPersonEmail(userId, token));
        activity.setPostedTime(Long.valueOf(System.currentTimeMillis()));
        activity.setUpdated(new Date());
        if (groupId != null && StringUtils.hasText((String)groupId.getGroupId())) {
            activity.setExternalId(groupId.getGroupId());
        }
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)activity);
        return null;
    }

    private String getPersonEmail(UserId userId, SecurityToken token) throws ProtocolException {
        try {
            Person person = (Person)this.personService.getPerson(userId, null, token).get();
            List emails = person.getEmails();
            if (CollectionUtils.isEmpty((Collection)emails)) {
                return person.getDisplayName();
            }
            return ((ListField)emails.get(0)).getValue();
        }
        catch (Exception e) {
            String shortMessage = "Could not retrieve the Person display namefor userId('" + userId + "')";
            String errorMessage = "An exception occured in the Shindig server." + this.getClass().getSimpleName() + "<br/>" + shortMessage;
            ErrorMail errorMail = new ErrorMail(shortMessage, errorMessage, e.getMessage(), this.getHost(), "Shindig");
            errorMail.setLocation(this.getClass().getName() + "#getPersonEmail");
            this.errorMessageMailer.sendErrorMail(errorMail);
            throw new RuntimeException(shortMessage, e);
        }
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            return "UNKNOWN";
        }
    }

    @Transactional
    public Future<Void> deleteActivities(UserId userId, GroupId groupId, String appId, Set<String> activityIds, SecurityToken token) throws ProtocolException {
        this.openSocialValidator.invariant(userId, groupId);
        StringBuilder queryString = new StringBuilder("delete from " + ACTIVITY + " where appId = :appId ");
        if (groupId != null) {
            queryString.append(" and externalId = :externalId ");
        }
        if (userId != null) {
            queryString.append(" and userId = :userId");
        }
        Query query = this.sessionFactory.getCurrentSession().createQuery(queryString.toString());
        query.setString("appId", appId);
        if (groupId != null) {
            query.setString("groupId", groupId.getGroupId());
        }
        if (userId != null) {
            query.setString("userId", userId.getUserId(token));
        }
        query.executeUpdate();
        return null;
    }

    @Transactional
    public Future<RestfulCollection<Activity>> getActivities(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
        this.openSocialValidator.invariant(userIds, groupId, appId);
        StringBuilder queryString = new StringBuilder("from " + ACTIVITY + " where 1 = 1 ");
        ArrayList<String> ids = null;
        if (StringUtils.hasText((String)appId)) {
            queryString.append("and appId = :appId ");
        }
        if (!CollectionUtils.isEmpty(userIds)) {
            ids = new ArrayList<String>();
            for (UserId userId : userIds) {
                ids.add(userId.getUserId(token));
                queryString.append(" and userId in (:ids) ");
            }
        }
        if (groupId != null && StringUtils.hasText((String)groupId.getGroupId())) {
            queryString.append(" and externalId = :externalId ");
        }
        Query query = this.sessionFactory.getCurrentSession().createQuery(queryString.toString());
        if (StringUtils.hasText((String)appId)) {
            query.setString("appId", appId);
        }
        if (!CollectionUtils.isEmpty(userIds)) {
            query.setParameterList("ids", ids);
        }
        if (groupId != null && StringUtils.hasText((String)groupId.getGroupId())) {
            query.setParameter("externalId", (Object)groupId.getGroupId());
        }
        List result = query.list();
        return ImmediateFuture.newInstance((Object)new RestfulCollection(result));
    }

    @Transactional
    public Future<RestfulCollection<Activity>> getActivities(UserId userId, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, Set<String> activityIds, SecurityToken token) throws ProtocolException {
        if (activityIds == null || !activityIds.isEmpty()) {
            // empty if block
        }
        return this.getActivities(new HashSet<UserId>(Collections.singletonList(userId)), groupId, appId, fields, options, token);
    }

    @Transactional
    public Future<Activity> getActivity(UserId userId, GroupId groupId, String appId, Set<String> fields, String activityId, SecurityToken token) throws ProtocolException {
        Activity activity = (Activity)this.sessionFactory.getCurrentSession().load(ActivityImpl.class, (Serializable)((Object)activityId));
        return ImmediateFuture.newInstance((Object)activity);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setOpenSocialId(OpenSocialValidator openSocialValidator) {
        this.openSocialValidator = openSocialValidator;
    }

    @Override
    public List<Activity> findActivityByGroups(Group group, int maxResult, int firstResult) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(ActivityImpl.class);
        criteria.add((Criterion)Restrictions.eq((String)"externalId", (Object)group.getId().getGroupId()));
        criteria.setMaxResults(maxResult);
        criteria.setFirstResult(firstResult);
        criteria.addOrder(Order.desc((String)"updated"));
        return criteria.list();
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setErrorMessageMailer(ErrorMessageMailer errorMessageMailer) {
        this.errorMessageMailer = errorMessageMailer;
    }

    public void setEnvironment(ContextEnvironment environment) {
        this.environment = environment;
    }
}

