/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import nl.surfnet.coin.shindig.protocol.ContextEnvironment;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.AlbumService;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.GroupService;
import org.apache.shindig.social.opensocial.spi.MediaItemService;
import org.apache.shindig.social.opensocial.spi.MessageService;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.sample.oauth.SampleOAuthDataStore;
import org.apache.shindig.social.sample.spi.JsonDbOpensocialService;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CoinGuiceModule
extends AbstractModule {
    private static AbstractApplicationContext context;

    public CoinGuiceModule() {
        context = new ClassPathXmlApplicationContext(new String[]{"coin-shindig-context.xml", "coin-shindig-properties-context.xml", "coin-shared-context.xml"});
    }

    protected void configure() {
        ContextEnvironment environment = (ContextEnvironment)context.getBean("environment");
        if (environment.isDummyMode()) {
            this.configureDummy();
        } else {
            this.configureReal();
        }
    }

    private void configureDummy() {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"shindig.canonical.json.db")).toInstance((Object)"sampledata/canonicaldb.json");
        this.bind(ActivityService.class).to(JsonDbOpensocialService.class);
        this.bind(AlbumService.class).to(JsonDbOpensocialService.class);
        this.bind(MediaItemService.class).to(JsonDbOpensocialService.class);
        this.bind(AppDataService.class).to(JsonDbOpensocialService.class);
        this.bind(PersonService.class).to(JsonDbOpensocialService.class);
        this.bind(MessageService.class).to(JsonDbOpensocialService.class);
        this.bind(GroupService.class).to(JsonDbOpensocialService.class);
        this.bind(OAuthDataStore.class).to(SampleOAuthDataStore.class);
    }

    private void configureReal() {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"shindig.canonical.json.db")).toInstance((Object)"sampledata/canonicaldb.json");
        this.bind(AlbumService.class).to(JsonDbOpensocialService.class);
        this.bind(MediaItemService.class).to(JsonDbOpensocialService.class);
        this.bind(ActivityService.class).toInstance((Object)((ActivityService)context.getBean("activityService")));
        this.bind(AppDataService.class).toInstance((Object)((AppDataService)context.getBean("appDataService")));
        this.bind(PersonService.class).toInstance((Object)((PersonService)context.getBean("personService")));
        this.bind(MessageService.class).toInstance((Object)((MessageService)context.getBean("messageService")));
        this.bind(GroupService.class).toInstance((Object)((GroupService)context.getBean("groupService")));
        this.bind(OAuthDataStore.class).toInstance((Object)((OAuthDataStore)context.getBean("oAuthDataStore")));
    }

    public static AbstractApplicationContext getContext() {
        return context;
    }
}

