/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import nl.surfnet.coin.shared.domain.ErrorMail;
import nl.surfnet.coin.shared.service.ErrorMessageMailer;
import nl.surfnet.coin.shindig.spi.AbstractRestDelegationService;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.core.model.GroupImpl;
import org.apache.shindig.social.opensocial.model.Group;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.GroupService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="groupService")
public class GroupServiceImpl
extends AbstractRestDelegationService
implements GroupService {
    private static final String GROUP_URL = "/social/groups/";
    @Autowired
    private ErrorMessageMailer errorMessageMailer;

    private Future<RestfulCollection<Group>> doGetGroups(String idOfUser, CollectionOptions options, SecurityToken token) throws IOException {
        String serviceProviderContext;
        StringBuilder url = new StringBuilder(this.getEnvironment().getBaseSocialApiUrl() + GROUP_URL + idOfUser + "?1=1");
        String vo = super.getVirtualOrganizationContext(token, options);
        if (!StringUtils.isBlank((String)vo)) {
            url.append("&vo=" + vo);
        }
        if (!StringUtils.isBlank((String)(serviceProviderContext = super.getServiceProviderContext(token)))) {
            url.append("&sp-entity-id=" + URLEncoder.encode(serviceProviderContext, "UTF-8"));
        }
        InputStream inputStream = this.executeHttpGet(url.toString());
        List<GroupImpl> constructGroups = this.constructGroups(inputStream);
        inputStream.close();
        ArrayList<GroupImpl> groups = new ArrayList<GroupImpl>();
        if (constructGroups != null) {
            groups.addAll(constructGroups);
        }
        return ImmediateFuture.newInstance((Object)new RestfulCollection(groups));
    }

    private List<GroupImpl> constructGroups(InputStream inputStream) {
        try {
            HashMap result = (HashMap)this.getObjectMapper().readValue(inputStream, HashMap.class);
            List entries = (List)result.get("entry");
            if (CollectionUtils.isEmpty((Collection)entries) || entries.get(0) instanceof List) {
                return null;
            }
            List entry = entries;
            ArrayList<GroupImpl> groupList = new ArrayList<GroupImpl>();
            for (Map groupMap : entry) {
                String id = (String)groupMap.get("id");
                String description = (String)groupMap.get("description");
                String title = (String)groupMap.get("title");
                String voot_membership_role = (String)groupMap.get("voot_membership_role");
                GroupImpl group = new GroupImpl();
                group.setDescription(description);
                group.setId(new GroupId(GroupId.Type.groupId, id));
                group.setTitle(title);
                group.setVoot_membership_role(voot_membership_role);
                groupList.add(group);
            }
            return groupList;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Future<RestfulCollection<Group>> getGroups(UserId userId, CollectionOptions options, Set<String> fields, SecurityToken token) {
        try {
            String onBehalfOf;
            String idOfUser = userId.getUserId(token);
            String string = onBehalfOf = token != null ? token.getOwnerId() : null;
            if (StringUtils.isNotBlank((String)onBehalfOf) && !idOfUser.equals(onBehalfOf)) {
                throw new IllegalArgumentException("Retrieval groups not granted as this " + idOfUser + " is not " + onBehalfOf);
            }
            this.logApiCall(token);
            return this.doGetGroups(idOfUser, options, token);
        }
        catch (Exception e) {
            String shortMessage = "Exception in getGroups(userId='" + userId.getUserId(token) + "')";
            String errorMessage = "An exception occured in the GroupService in the Shindig server\nconnecting to the EngineBlock PHP endpoint:<br/><br/>" + this.getClass().getSimpleName() + "<br/>" + shortMessage;
            ErrorMail errorMailDetails = new ErrorMail(shortMessage, errorMessage, userId.getUserId(token), e.getMessage(), this.getHost(), "Shindig");
            this.errorMessageMailer.sendErrorMail(errorMailDetails);
            throw new RuntimeException(shortMessage, e);
        }
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            return "UNKNOWN";
        }
    }

    public void setErrorMessageMailer(ErrorMessageMailer errorMessageMailer) {
        this.errorMessageMailer = errorMessageMailer;
    }
}

