/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.util.Set;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="openSocialId")
public class OpenSocialValidator {
    public void invariant(Set<UserId> userIds, GroupId groupId) {
        if (groupId == null && (userIds == null || userIds.isEmpty())) {
            throw new IllegalArgumentException("Either groupId or userIds must be provided");
        }
        this.invariant(groupId);
    }

    public void invariant(Set<UserId> userIds, GroupId groupId, String appId) {
        if (groupId == null && (userIds == null || userIds.isEmpty()) && !StringUtils.hasText((String)appId)) {
            throw new IllegalArgumentException("Either groupId, userIds or appId must be provided");
        }
        this.invariant(groupId);
    }

    public void invariant(UserId userId, GroupId groupId) {
        if (userId == null && groupId == null) {
            throw new IllegalArgumentException("Either groupId or userId must be provided");
        }
        this.invariant(groupId);
    }

    public void invariant(GroupId groupId) {
    }

    public void invariant(UserId userId) {
        if (userId == null) {
            throw new IllegalArgumentException("userId must be provided");
        }
    }

    public void invariant(Set<UserId> userIds) {
        this.invariant(userIds, false);
    }

    public void invariant(Set<UserId> userIds, boolean requiresSingleUser) {
        if (userIds == null || userIds.isEmpty()) {
            throw new IllegalArgumentException("At least one userId must be provided");
        }
        if (requiresSingleUser && userIds.size() > 1) {
            throw new IllegalArgumentException("Only one userId may be specified. Multiple userIds are not supported");
        }
    }
}

