/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.util.Collection;
import nl.surfnet.coin.shindig.oauth.CoinOAuthTokenInfo;
import nl.surfnet.coin.shindig.spi.TokenInfoService;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="tokenInfoService")
@Transactional
public class TokenInfoServiceImpl
implements TokenInfoService {
    @Autowired
    private SessionFactory sessionFactory;
    private static final String TOKEN_INFO = CoinOAuthTokenInfo.class.getName();

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public CoinOAuthTokenInfo getCoinOAuthTokenInfo(String userId, String gadgetUri, String moduleId, String tokenName, String serviceName) {
        Criteria crit = this.sessionFactory.getCurrentSession().createCriteria(TOKEN_INFO);
        crit.add((Criterion)Restrictions.eq((String)"userId", (Object)userId)).add((Criterion)Restrictions.eq((String)"appUrl", (Object)gadgetUri)).add((Criterion)Restrictions.eq((String)"moduleId", (Object)moduleId)).add((Criterion)Restrictions.eq((String)"tokenName", (Object)tokenName)).add((Criterion)Restrictions.eq((String)"serviceName", (Object)serviceName));
        crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return (CoinOAuthTokenInfo)DataAccessUtils.singleResult((Collection)crit.list());
    }

    @Override
    public void saveCoinOAuthTokenInfo(CoinOAuthTokenInfo tokenInfo) {
        this.sessionFactory.getCurrentSession().saveOrUpdate(TOKEN_INFO, (Object)tokenInfo);
    }

    @Override
    public void deleteCoinOAuthTokenInfo(String userId, String gadgetUri, String moduleId, String tokenName, String serviceName) {
        CoinOAuthTokenInfo tokenInfo = this.getCoinOAuthTokenInfo(userId, gadgetUri, moduleId, tokenName, serviceName);
        if (tokenInfo != null) {
            this.sessionFactory.getCurrentSession().delete(TOKEN_INFO, (Object)tokenInfo);
        }
    }
}

