/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.teams.service;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import nl.surfnet.coin.teams.model.ScimEvent;
import nl.surfnet.coin.teams.model.ScimMember;
import nl.surfnet.coin.teams.service.ProvisioningManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;

public class ASyncProvisioningManager
implements ProvisioningManager {
    protected static final Logger log = LoggerFactory.getLogger(ASyncProvisioningManager.class);
    private HttpClient client;
    private String baseUri;
    private String username;
    private String password;
    private String extraUri;
    private ObjectMapper mapper = new ObjectMapper().enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL).setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
    private UsernamePasswordCredentials credentials;

    @Override
    @Async
    public void groupEvent(String teamId, String displayName, ProvisioningManager.Operation operation) {
        try {
            HttpPost request;
            ScimEvent event = new ScimEvent();
            String uriPath = this.baseUri;
            switch (operation) {
                case CREATE: {
                    event.setId(teamId);
                    event.setDisplayName(displayName);
                    request = new HttpPost(uriPath);
                    break;
                }
                case DELETE: {
                    uriPath = uriPath.concat("/").concat(URLEncoder.encode(teamId, "UTF-8"));
                    request = new HttpDelete(uriPath);
                    break;
                }
                case UPDATE: {
                    event.setDisplayName(displayName);
                    uriPath = uriPath.concat("/").concat(URLEncoder.encode(teamId, "UTF-8"));
                    request = new HttpPatch(uriPath);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported operation for groupEvent(" + (Object)((Object)operation) + ")");
                }
            }
            this.execute((HttpUriRequest)request, event);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    @Async
    public void teamMemberEvent(String teamId, String memberId, String role, ProvisioningManager.Operation operation) {
        try {
            ScimEvent event = new ScimEvent();
            String uriPath = this.extraUri.concat("/").concat(URLEncoder.encode(teamId, "UTF-8"));
            HttpPatch request = new HttpPatch(uriPath);
            switch (operation) {
                case CREATE: {
                    event.setMembers(Arrays.asList(new ScimMember(memberId, Arrays.asList(role), null)));
                    break;
                }
                case DELETE: {
                    event.setMembers(Arrays.asList(new ScimMember(memberId, null, operation.name().toLowerCase())));
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported operation for teamMemberEvent(" + (Object)((Object)operation) + ")");
                }
            }
            this.execute((HttpUriRequest)request, event);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    @Async
    public void roleEvent(String teamId, String memberId, String role, ProvisioningManager.Operation operation) {
        try {
            ScimEvent event = new ScimEvent();
            String uriPath = this.extraUri.concat("/").concat(URLEncoder.encode(teamId, "UTF-8")).concat("/").concat(URLEncoder.encode(memberId, "UTF-8"));
            HttpPatch request = new HttpPatch(uriPath);
            switch (operation) {
                case CREATE: {
                    event.setMembers(Arrays.asList(new ScimMember(null, Arrays.asList(role), null)));
                    break;
                }
                case DELETE: {
                    event.setMembers(Arrays.asList(new ScimMember(null, Arrays.asList(role), operation.name().toLowerCase())));
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported operation for roleEvent(" + (Object)((Object)operation) + ")");
                }
            }
            this.execute((HttpUriRequest)request, event);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public void init(Environment env) {
        this.baseUri = env.getRequiredProperty("provisioner.baseurl").concat("/Groups/v1.1");
        this.extraUri = env.getRequiredProperty("provisioner.baseurl").concat("/extra/Groups/v1.1");
        this.username = env.getRequiredProperty("provisioner.user");
        this.password = env.getRequiredProperty("provisioner.password");
        this.credentials = new UsernamePasswordCredentials(this.username, this.password);
        PoolingClientConnectionManager cxMgr = new PoolingClientConnectionManager();
        cxMgr.setMaxTotal(100);
        this.client = new DefaultHttpClient((ClientConnectionManager)cxMgr);
    }

    private void execute(HttpUriRequest request, ScimEvent event) throws IOException, JsonGenerationException, JsonMappingException, ClientProtocolException {
        request.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        request.addHeader(BasicScheme.authenticate((Credentials)this.credentials, (String)"UTF-8", (boolean)false));
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest enclosingRequest = (HttpEntityEnclosingRequest)request;
            StringEntity entity = new StringEntity(this.mapper.writeValueAsString((Object)event), ContentType.APPLICATION_JSON);
            enclosingRequest.setEntity((HttpEntity)entity);
        }
        this.doExecute(request);
    }

    private void handleException(Throwable e) {
        log.error("ASyncProvisioningManager#handleException", e);
        throw new RuntimeException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doExecute(HttpUriRequest request) throws IOException, ClientProtocolException {
        log.info("Broadcasting team change (" + request + ")");
        HttpEntity entity = null;
        try {
            HttpResponse response = this.client.execute(request);
            entity = response.getEntity();
            int status = response.getStatusLine().getStatusCode();
            if (status < 200 || status > 299) {
                throw new RuntimeException("Status = " + status);
            }
        }
        catch (Throwable throwable) {
            EntityUtils.consume(entity);
            throw throwable;
        }
        EntityUtils.consume((HttpEntity)entity);
    }
}

