/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.db;

import java.io.InputStream;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public abstract class AbstractInMemoryDatabaseTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInMemoryDatabaseTest.class);
    private JdbcTemplate jdbcTemplate;

    public abstract String getMockDataContentFilename();

    public abstract String getMockDataCleanUpFilename();

    @Before
    public void before() throws Exception {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setPassword("");
        dataSource.setUsername("sa");
        String url = this.getDataSourceUrl();
        dataSource.setUrl(url);
        dataSource.setDriverClassName("org.hsqldb.jdbcDriver");
        this.jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        ClassPathResource resource = new ClassPathResource(this.getMockDataContentFilename());
        logger.debug("Loading database content from " + resource);
        if (resource.exists()) {
            String[] split;
            String sql = IOUtils.toString((InputStream)resource.getInputStream());
            for (String s : split = sql.split(";")) {
                if (!StringUtils.hasText((String)s)) continue;
                this.jdbcTemplate.execute(s + ';');
            }
        }
    }

    protected String getDataSourceUrl() {
        return "jdbc:hsqldb:mem:coin";
    }

    @After
    public void afterClass() throws Exception {
        ClassPathResource resource = new ClassPathResource(this.getMockDataCleanUpFilename());
        if (resource.exists()) {
            String[] split;
            logger.debug("Cleaning database content from " + resource);
            String sql = IOUtils.toString((InputStream)resource.getInputStream());
            for (String s : split = sql.split(";")) {
                if (!StringUtils.hasText((String)s)) continue;
                this.jdbcTemplate.execute(s + ';');
            }
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }
}

