/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.mock;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class MockHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(MockHandler.class);
    private Resource[] responseResource;
    private int status;

    public MockHandler(Server server) {
        this.setServer(server);
    }

    private void respond(HttpServletResponse response, HttpServletRequest request) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        String requestURI = request.getRequestURI();
        InputStream inputStream = this.getResponseInputStream(requestURI);
        logger.debug("Received Http request ('" + requestURI + "')");
        if (request.getMethod().equals("POST")) {
            logger.debug("Received POST request ('" + IOUtils.toString((InputStream)request.getInputStream()) + "')");
        }
        if (this.status != 0) {
            response.setStatus(this.status);
        }
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        outputStream.flush();
    }

    protected InputStream getResponseInputStream(String requestURI) throws IOException {
        InputStream inputStream = this.responseResource[0].getInputStream();
        if (this.responseResource.length > 1) {
            Resource[] stack = new Resource[this.responseResource.length - 1];
            System.arraycopy(this.responseResource, 1, stack, 0, this.responseResource.length - 1);
            this.responseResource = stack;
        }
        return inputStream;
    }

    public void setResponseResource(Resource responseResource) {
        this.responseResource = new Resource[]{responseResource};
    }

    public void setResponseResource(Resource[] responseResource) {
        this.responseResource = responseResource;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.invariant();
        this.addContentHeader(response);
        this.respond(response, request);
    }

    private void addContentHeader(HttpServletResponse response) {
        String description = this.responseResource[0].getDescription();
        String contentType = description.contains("json") ? "application/json" : (description.contains("xml") ? "text/xml" : "text/html");
        response.addHeader("Content-Type", contentType);
    }

    private void invariant() {
        if (this.responseResource == null || this.responseResource.length == 0) {
            throw new RuntimeException("No responseResource set");
        }
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

