/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.testsp.service;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.opensocial.models.Group;
import org.opensocial.models.Person;

/**
 * Responsible for getting all the members for a certain group. The actual
 * backend implementation should (but not strictly required) support the
 * OpenSocial specification.
 */
public interface OpenSocialService {

  /**
   * Get Team members;
   * 
   * @param groupId
   *          the unique identifier
   * @return the {@link Person} collection of the team
   */
  List<Person> getTeamMembers(String personId, String groupId);

  /**
   * Get Team members;
   * 
   * @param groupId
   *          the unique identifier
   * @return the {@link Person} collection of the team
   */
  List<Person> getTeamMembers(String personId, String onBehalfOfUserId, String groupId);

  /**
   * Get all of the groups for a person
   * 
   * @param personId
   *          the unique identifier for the person
   * @return the {@link Group} collection for the person
   */
  List<Group> getTeams(String personId);

  /**
   * Get the OpenSocial Person
   * 
   * @param userId
   *          the unique identifier
   * @return the {@link Person}
   */
  Person getPerson(String userId);
  
  /**
   * Get the OpenSocial Person
   * 
   * @param userId
   *          the unique identifier
   * @return the {@link Person}
   */
  Person getPerson(String userId, String onBehalfOfUserId);

  /**
   * @param personId
   * @param onBehalfOfUserId
   * @return
   */
  List<Group> getTeams(String personId, String onBehalfOfUserId);
}
