/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.testsp.service;

import java.io.IOException;
import java.util.List;

import nl.surfnet.coin.testsp.interceptor.LoginInterceptor;

import org.opensocial.Client;
import org.opensocial.Request;
import org.opensocial.RequestException;
import org.opensocial.models.Group;
import org.opensocial.models.Person;
import org.opensocial.services.GroupsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * A {@link OpenSocialService} using the OpenSocial client to retrieve the
 * data
 */
@Component("openSocialService")
public class OpenSocialServiceImpl implements OpenSocialService {

  private static final String restTemplate = "people/{guid}/{selector}/{pid}";
  
  protected static final String SELF = "@self";


  @Autowired
  private OAuthServiceConsumer serviceConsumer;

 
  /* (non-Javadoc)
   * @see nl.surfnet.coin.calendar.service.CalendarGroupService#getTeamMembers(java.lang.String, javax.servlet.http.HttpServletRequest)
   */
  @Override
  public List<Person> getTeamMembers(String personId, String groupId) {
    Request request = new Request(restTemplate, "people.get", "GET");
    request.setModelClass(Person.class);
    request.setGuid(personId);
    request.setSelector(groupId);
    try {
      return serviceConsumer.getClient(serviceConsumer.getToken(personId)).send(request).getEntries();
    } catch (RequestException e) {
      throw new IllegalArgumentException(
          "Unable to retrieve the team members for team '" + groupId + "'", e);
    } catch (IOException e) {
      throw new IllegalArgumentException(
          "Unable to retrieve the team members for team '" + groupId + "'", e);
    }
  }


  /* (non-Javadoc)
   * @see nl.surfnet.coin.calendar.service.CalendarGroupService#getTeams(java.lang.String, javax.servlet.http.HttpServletRequest)
   */
  @Override
  public List<Group> getTeams(String personId) {
    Request request = GroupsService.getGroups(personId);
    try {
      Client client = serviceConsumer.getClient(serviceConsumer.getToken(personId));
      return client.send(request).getEntries();
    } catch (RequestException e) {
      throw new IllegalArgumentException(
          "Unable to retrieve the teams for person '" + personId + "'", e);
    } catch (IOException e) {
      throw new IllegalArgumentException(
          "Unable to retrieve the teams for person '" + personId + "'", e);
    }
  }
  
  /* (non-Javadoc)
   * @see nl.surfnet.coin.calendar.service.CalendarGroupService#getTeams(java.lang.String, javax.servlet.http.HttpServletRequest)
   */
  @Override
  public List<Group> getTeams(String personId, String onBehalfOfUserId) {
    Request request = GroupsService.getGroups(personId);
    try {
      Client client = serviceConsumer.getClient(serviceConsumer.getToken(onBehalfOfUserId));
      return client.send(request).getEntries();
    } catch (RequestException e) {
      throw new IllegalArgumentException(
          "Unable to retrieve the teams for person '" + personId + "'", e);
    } catch (IOException e) {
      throw new IllegalArgumentException(
          "Unable to retrieve the teams for person '" + personId + "'", e);
    }
  }
  
  @Override
  public Person getPerson(String userId) {
    Request request = new Request(restTemplate, "people.get", "GET");
    request.setModelClass(Person.class);
    request.setSelector(SELF);
    request.setGuid(userId);
    try {
       return serviceConsumer.getClient(serviceConsumer.getToken(userId)).send(request).getEntry();
    } catch (RequestException e) {
      throw new IllegalArgumentException(
          "Unable to retrieve the person with uid: '" + userId + "'", e);
    } catch (IOException e) {
      throw new IllegalArgumentException(
          "Unable to retrieve the person with uid: '" + userId + "'", e);
    }
  }


  /* (non-Javadoc)
   * @see nl.surfnet.coin.testsp.service.OpenSocialService#getPerson(java.lang.String, java.lang.String)
   */
  @Override
  public Person getPerson(String userId, String onBehalfOfUserId) {
    Request request = new Request(restTemplate, "people.get", "GET");
    request.setModelClass(Person.class);
    request.setSelector(SELF);
    request.setGuid(userId);
    try {
       return serviceConsumer.getClient(serviceConsumer.getToken(onBehalfOfUserId)).send(request).getEntry();
    } catch (RequestException e) {
      throw new IllegalArgumentException(
          "Unable to retrieve the person with uid: '" + userId + "'", e);
    } catch (IOException e) {
      throw new IllegalArgumentException(
          "Unable to retrieve the person with uid: '" + userId + "'", e);
    }
  }


  /* (non-Javadoc)
   * @see nl.surfnet.coin.testsp.service.OpenSocialService#getTeamMembers(java.lang.String, java.lang.String, java.lang.String)
   */
  @Override
  public List<Person> getTeamMembers(String personId, String onBehalfOfUserId,
      String groupId) {
    Request request = new Request(restTemplate, "people.get", "GET");
    request.setModelClass(Person.class);
    request.setGuid(personId);
    request.setSelector(groupId);
    try {
      return serviceConsumer.getClient(serviceConsumer.getToken(onBehalfOfUserId)).send(request).getEntries();
    } catch (RequestException e) {
      throw new IllegalArgumentException(
          "Unable to retrieve the team members for team '" + groupId + "'", e);
    } catch (IOException e) {
      throw new IllegalArgumentException(
          "Unable to retrieve the team members for team '" + groupId + "'", e);
    }
  }

}
