/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.monitoring;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import nl.surfnet.coin.monitoring.MujinaClient;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tester {
    private static final Logger LOG = LoggerFactory.getLogger(Tester.class);
    private WebDriver driver = new HtmlUnitDriver(true);
    private MujinaClient mujinaClient;

    public Tester(URI serverBaseUri) throws Exception {
        this.driver.manage().deleteAllCookies();
        this.mujinaClient = new MujinaClient(this.driver, serverBaseUri);
    }

    public void runTests() throws IOException {
        try {
            LOG.info("Running test for login flow using Mujina SP/IdP");
            this.loginFlow();
        }
        catch (Throwable e) {
            File tmpFile = File.createTempFile("monitor", ".txt");
            String output = String.format("Current URL: %s\nPage source:\n%s", this.driver.getCurrentUrl(), this.driver.getPageSource());
            FileUtils.writeStringToFile((File)tmpFile, (String)output);
            LOG.info("Caught exception. WebDriver's current state has been dumped in file: {} Will rethrow exception.", (Object)tmpFile.getPath());
            throw new RuntimeException(e);
        }
        finally {
            this.driver.quit();
        }
    }

    public void loginFlow() {
        this.mujinaClient.spHome();
        LOG.debug("url: {}", (Object)this.driver.getCurrentUrl());
        this.mujinaClient.protectedPage();
        Assert.assertTrue((String)("Expecting a WAYF. URL was: " + this.driver.getCurrentUrl()), (boolean)this.driver.getPageSource().contains("Select an institution to login to the service"));
        this.chooseIdPByLabel(this.driver, "https://monitoring-idp");
        this.mujinaClient.login("monitor-user", "somepass");
        Assert.assertTrue((String)("should be on SP, while current URL is: " + this.driver.getCurrentUrl()), (boolean)this.driver.getCurrentUrl().contains("/sp/user.jsp"));
        Assert.assertTrue((String)"Should contain SAML attributes", (boolean)this.driver.findElement(By.id((String)"assertionAttributes")).getText().contains("j.doe@example.com"));
        Assert.assertTrue((String)"Should contain my full name", (boolean)this.driver.getPageSource().contains("John Doe"));
    }

    private void chooseIdPByLabel(WebDriver driver, String label) {
        String xpathExpression = String.format("//a[@data-idp=\"%s\"]", StringEscapeUtils.escapeXml((String)label));
        WebElement element = driver.findElement(By.xpath((String)xpathExpression));
        element.click();
    }
}

