/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.monitoring;

import java.util.List;
import nl.surfnet.coin.api.client.OpenConextOAuthClientImpl;
import nl.surfnet.coin.api.client.domain.Person;
import nl.surfnet.coin.monitoring.AbstractMonitor;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiMonitor
extends AbstractMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(ApiMonitor.class);
    private static final String nonExistingPersonId = "urn:collab:some-nonexisting-org:monitoring-user";

    public static void main(String[] args) throws Exception {
        new ApiMonitor().monitor();
    }

    public void monitor() {
        try {
            String apiBaseUrl = this.getProperty("apiBaseUrl");
            String clientId = this.getProperty("apiClientId");
            String secret = this.getProperty("apiClientSecret");
            String personId = this.getProperty("apiPersonId");
            String personFullName = this.getProperty("apiPersonFullName");
            OpenConextOAuthClientImpl client = new OpenConextOAuthClientImpl();
            client.setConsumerKey(clientId);
            client.setConsumerSecret(secret);
            client.setEndpointBaseUrl(apiBaseUrl);
            Person person = client.getPerson(personId, null);
            Assert.assertNotNull((Object)person);
            Assert.assertEquals((Object)personFullName, (Object)person.getDisplayName());
            try {
                client.getPerson(nonExistingPersonId, null);
                Assert.fail((String)"Person-call with non-existent user should throw exception");
            }
            catch (RuntimeException e) {
                Assert.assertTrue((String)"Response of person-call with non-existent user should be a 404", (boolean)e.getMessage().contains("Error response: 404"));
            }
            List groups = client.getGroups20(personId, null);
            Assert.assertNotNull((String)("Groups-call for person " + personId + " should not be null"), (Object)groups);
            try {
                client.getGroups20(nonExistingPersonId, null);
                Assert.fail((String)"Groups-call with non-existent user should throw exception");
            }
            catch (RuntimeException e) {
                Assert.assertTrue((String)"Response of groups-call with non-existent user should be a 404", (boolean)e.getMessage().contains("Error response: 404"));
            }
        }
        catch (Throwable e) {
            LOG.error("Exception while running, will exit(2)", e);
            System.exit(2);
        }
    }
}

