/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.monitoring;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.opensaml.util.resource.ClasspathResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MujinaServer {
    private static final Logger LOG = LoggerFactory.getLogger(MujinaServer.class);
    private static final String MUJINA_VERSION = "3.1.0";
    public static final String KEYSTORE_PASSWORD = "000123";
    private static final String SP_ENTITY_ID = "https://monitoring-sp";
    private static final String IDP_ENTITY_ID = "https://monitoring-idp";
    public static final String MUJINA_REPO_BASE = "https://build.surfconext.nl/repository/public/releases";
    private Server server;
    private int sslPort;
    private X509Certificate certificate;
    private PrivateKey privateKey;

    public URI setupServer(String conextDomain, String privateKeyPath, String certPath, int sslPort) throws Exception {
        this.sslPort = sslPort;
        String baseURI = "https://localhost:" + sslPort;
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.certificate = (X509Certificate)new PEMReader((Reader)new InputStreamReader(new ClasspathResource(certPath).getInputStream())).readObject();
        Object key = new PEMReader((Reader)new InputStreamReader(new ClasspathResource(privateKeyPath).getInputStream())).readObject();
        this.privateKey = key instanceof KeyPair ? ((KeyPair)key).getPrivate() : (PrivateKey)key;
        this.certificate = (X509Certificate)new PEMReader((Reader)new InputStreamReader(new ClasspathResource(certPath).getInputStream())).readObject();
        Assert.notNull((Object)this.certificate, (String)("Could not properly read certificate:" + certPath));
        Assert.notNull((Object)this.certificate, (String)("Could not properly read privateKey:" + privateKeyPath));
        this.server = new Server();
        this.configureSSL(this.server, sslPort);
        this.deployMujinaApps(this.server);
        this.server.start();
        this.setSAMLEndpoints(baseURI, conextDomain);
        return URI.create(baseURI);
    }

    private void setSAMLEndpoints(String baseURI, String conextDomain) throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        SSLSocketFactory sslsf = new SSLSocketFactory(new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        });
        httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", this.sslPort, (SchemeSocketFactory)sslsf));
        HttpPut put = new HttpPut(baseURI + "/sp/api/ssoServiceURL");
        String ssoServiceUrl = String.format("https://engine.%s/authentication/idp/single-sign-on", conextDomain);
        put.setEntity((HttpEntity)new StringEntity(String.format("{\"value\": \"%s\"}", ssoServiceUrl), ContentType.APPLICATION_JSON));
        httpClient.execute((HttpUriRequest)put);
        put = new HttpPut(baseURI + "/sp/api/assertionConsumerServiceURL");
        String assertionConsumerUrl = String.format("%s/sp/AssertionConsumerService", baseURI);
        put.setEntity((HttpEntity)new StringEntity(String.format("{\"value\": \"%s\"}", assertionConsumerUrl), ContentType.APPLICATION_JSON));
        httpClient.execute((HttpUriRequest)put);
        put = new HttpPut(baseURI + "/sp/api/entityid");
        put.setEntity((HttpEntity)new StringEntity(String.format("{\"value\": \"%s\"}", SP_ENTITY_ID), ContentType.APPLICATION_JSON));
        httpClient.execute((HttpUriRequest)put);
        put = new HttpPut(baseURI + "/idp/api/entityid");
        put.setEntity((HttpEntity)new StringEntity(String.format("{\"value\": \"%s\"}", IDP_ENTITY_ID), ContentType.APPLICATION_JSON));
        httpClient.execute((HttpUriRequest)put);
        put = new HttpPut(baseURI + "/idp/api/needs-signing");
        put.setEntity((HttpEntity)new StringEntity(String.format("{\"value\": \"%s\"}", "true"), ContentType.APPLICATION_JSON));
        httpClient.execute((HttpUriRequest)put);
        HttpPost post = new HttpPost(baseURI + "/idp/api/signing-credential");
        String certificate = new String(Base64.encodeBase64((byte[])this.certificate.getEncoded()));
        String key = new String(Base64.encodeBase64((byte[])this.privateKey.getEncoded()));
        String content = String.format("{\"certificate\": \"%s\", \"key\": \"%s\"}", certificate, key);
        LOG.debug("Signing content: {}", (Object)content);
        post.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
        HttpResponse response = httpClient.execute((HttpUriRequest)post);
    }

    private KeyStore createKeystore() throws Exception {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(null, KEYSTORE_PASSWORD.toCharArray());
        keystore.setKeyEntry("alias", this.privateKey, KEYSTORE_PASSWORD.toCharArray(), new Certificate[]{this.certificate});
        return keystore;
    }

    private void deployMujinaApps(Server server) throws MalformedURLException {
        String mujinaIdpUrl = String.format("%s/org/surfnet/coin/mujina-idp/%s/mujina-idp-%s.war", MUJINA_REPO_BASE, MUJINA_VERSION, MUJINA_VERSION);
        String mujinaSpUrl = String.format("%s/org/surfnet/coin/mujina-sp/%s/mujina-sp-%s.war", MUJINA_REPO_BASE, MUJINA_VERSION, MUJINA_VERSION);
        WebAppContext idpWebapp = new WebAppContext();
        idpWebapp.setContextPath("/idp");
        idpWebapp.setWar(this.getLocallyCachedWarFile(new URL(mujinaIdpUrl)));
        WebAppContext spWebapp = new WebAppContext();
        spWebapp.setContextPath("/sp");
        spWebapp.setWar(this.getLocallyCachedWarFile(new URL(mujinaSpUrl)));
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{idpWebapp, spWebapp});
        server.setHandler((Handler)handlers);
    }

    public String getLocallyCachedWarFile(URL url) {
        String urlPath = url.getPath();
        File file = new File(FileUtils.getTempDirectoryPath() + "/" + FilenameUtils.getName((String)urlPath));
        if (file.exists()) {
            LOG.debug("File {} exists already (downloaded before), will use this, for given URL {}", (Object)file.getPath(), (Object)url);
        } else {
            LOG.debug("File {} does not exist yet, will download from {}", (Object)file.getPath(), (Object)url);
            try {
                FileUtils.copyURLToFile((URL)url, (File)file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return file.getPath();
    }

    public void configureSSL(Server server, int port) throws Exception {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStore(this.createKeystore());
        sslContextFactory.setKeyStorePassword(KEYSTORE_PASSWORD);
        SslSelectChannelConnector connector = new SslSelectChannelConnector(sslContextFactory);
        connector.setPort(port);
        server.addConnector((Connector)connector);
    }

    public void stop() throws Exception {
        LOG.debug("Tearing down Jetty servlet container");
        this.server.stop();
        this.cleanup();
    }

    private void cleanup() throws Exception {
        File[] files;
        File tmp = new File(FileUtils.getTempDirectoryPath());
        for (File file : files = tmp.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("jetty-0.0.0.0-8443-mujina");
            }
        })) {
            if (file.delete()) continue;
            LOG.debug("can't delete file " + file.getName());
        }
    }
}

