/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.nio.charset.Charset;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;

public class StringHttpHandler
implements HttpHandler {
    private final String contentType;
    private final String body;
    private final Charset charset;

    public StringHttpHandler(String contentType, String body) {
        this(contentType, body, Charset.forName("UTF-8"));
    }

    public StringHttpHandler(String contentType, String body, Charset charset) {
        this.contentType = contentType;
        this.charset = charset;
        this.body = body;
    }

    @Override
    public void handleHttpRequest(HttpRequest request, HttpResponse response, HttpControl control) {
        response.charset(this.charset).header("Content-Type", this.contentType + "; charset=" + this.charset.name()).header("Content-Length", this.body.length()).content(this.body).end();
    }
}

