/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.net.INetAddress;

public class NetworkInterface {
    private final String name;
    private final Iterable<INetAddress> inetAddresses;
    private boolean isLoopback;

    public NetworkInterface(java.net.NetworkInterface networkInterface) {
        this(networkInterface.getName(), NetworkInterface.asIterableAddr(networkInterface.getInetAddresses()));
        try {
            this.isLoopback = networkInterface.isLoopback();
        }
        catch (SocketException ex) {
            Logger.getLogger(NetworkInterface.class.getName()).log(Level.WARNING, null, ex);
            this.isLoopback = this.isLoopBackFromINetAddresses(NetworkInterface.asIterableAddr(networkInterface.getInetAddresses()));
        }
    }

    NetworkInterface(String name, Iterable<INetAddress> inetAddresses) {
        this.name = name;
        this.inetAddresses = inetAddresses;
    }

    NetworkInterface(String name, INetAddress ... inetAddresses) {
        this(name, Arrays.asList(inetAddresses));
        this.isLoopback = this.isLoopBackFromINetAddresses(Arrays.asList(inetAddresses));
    }

    public boolean isIp4AddressBindingOnly() {
        return this.getIp6Address() == null;
    }

    public boolean isLoopBack() {
        return this.isLoopback;
    }

    public final boolean isLoopBackFromINetAddresses(Iterable<INetAddress> inetAddresses) {
        Iterator<INetAddress> iterator = inetAddresses.iterator();
        return iterator.hasNext() && iterator.next().isLoopbackAddress();
    }

    public INetAddress getIp4LoopbackOnly() {
        INetAddress lastFound = null;
        if (!this.isLoopback) {
            return lastFound;
        }
        for (INetAddress inetAddress : this.inetAddresses) {
            if (!inetAddress.isLoopbackAddress() || !inetAddress.isIPv4Address()) continue;
            lastFound = inetAddress;
        }
        return lastFound;
    }

    public INetAddress getIp4NonLoopBackOnly() {
        for (INetAddress inetAddress : this.inetAddresses) {
            if (inetAddress.isLoopbackAddress() || !inetAddress.isIPv4Address()) continue;
            return inetAddress;
        }
        return null;
    }

    public INetAddress getIp6Address() {
        for (INetAddress inetAddress : this.inetAddresses) {
            if (!inetAddress.isIPv6Address()) continue;
            return inetAddress;
        }
        return null;
    }

    public Iterable<INetAddress> getInetAddresses() {
        return this.inetAddresses;
    }

    public String getName() {
        return this.name;
    }

    static Iterable<INetAddress> asIterableAddr(Enumeration<InetAddress> tEnumeration) {
        ArrayList<INetAddress> result = new ArrayList<INetAddress>();
        while (tEnumeration.hasMoreElements()) {
            result.add(new INetAddress(tEnumeration.nextElement()));
        }
        return Collections.unmodifiableList(result);
    }
}

