/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler.logging;

import org.webbitserver.EventSourceConnection;
import org.webbitserver.EventSourceHandler;
import org.webbitserver.handler.logging.LogSink;

class LoggingEventSourceHandler
implements EventSourceHandler {
    private final LogSink logSink;
    private final EventSourceConnection loggingConnection;
    private final EventSourceHandler handler;

    LoggingEventSourceHandler(LogSink logSink, EventSourceConnection loggingConnection, EventSourceHandler handler) {
        this.logSink = logSink;
        this.loggingConnection = loggingConnection;
        this.handler = handler;
    }

    @Override
    public void onOpen(EventSourceConnection connection) throws Exception {
        this.logSink.eventSourceConnectionOpen(connection);
        this.handler.onOpen(this.loggingConnection);
    }

    @Override
    public void onClose(EventSourceConnection connection) throws Exception {
        this.logSink.eventSourceConnectionClose(connection);
        this.logSink.httpEnd(connection.httpRequest());
        this.handler.onClose(this.loggingConnection);
    }
}

