/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.monitoring;

import java.util.Collections;
import java.util.List;
import nl.surfnet.coin.monitoring.AbstractMonitor;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;

public class VootMonitor
extends AbstractMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(VootMonitor.class);
    private static final String nonExistingPersonId = "urn:collab:person:some-nonexisting-org:monitoring-user";

    public static void main(String[] args) throws Exception {
        VootMonitor vootMonitor = new VootMonitor();
        if (args.length == 4) {
            vootMonitor.doMonitor(args[0], args[1], args[2], args[3]);
        } else {
            vootMonitor.monitor();
        }
    }

    public void monitor() {
        String conextDomain = this.getProperty("conextDomain");
        String clientId = this.getProperty("vootClientId");
        String secret = this.getProperty("vootClientSecret");
        String personId = this.getProperty("vootPersonId");
        this.doMonitor(conextDomain, clientId, secret, personId);
    }

    public void doMonitor(String conextDomain, String clientId, String secret, String personId) {
        try {
            ClientCredentialsResourceDetails details = new ClientCredentialsResourceDetails();
            details.setAccessTokenUri("https://authz." + conextDomain + "/oauth/token");
            details.setClientId(clientId);
            details.setClientSecret(secret);
            details.setScope(Collections.singletonList("groups"));
            OAuth2RestTemplate template = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)details);
            List groups = (List)template.getForObject("https://voot." + conextDomain + "/internal/groups/{userId}", List.class, new Object[]{personId});
            Assert.assertFalse((boolean)groups.isEmpty());
            groups = (List)template.getForObject("https://voot." + conextDomain + "/internal/groups/{userId}", List.class, new Object[]{nonExistingPersonId});
            Assert.assertTrue((boolean)groups.isEmpty());
        }
        catch (Throwable e) {
            LOG.error("Exception while running, will exit(2)", e);
            System.exit(2);
        }
    }
}

