/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.seleniumemulation.ElementFinder;
import org.openqa.selenium.internal.seleniumemulation.JavascriptLibrary;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;

public class GetText
extends SeleneseCommand<String> {
    private final JavascriptLibrary library;
    private final ElementFinder finder;

    public GetText(JavascriptLibrary library, ElementFinder finder) {
        this.library = library;
        this.finder = finder;
    }

    @Override
    protected String handleSeleneseCommand(WebDriver driver, String locator, String ignored) {
        String getText = this.library.getSeleniumScript("getText.js");
        try {
            return (String)((JavascriptExecutor)driver).executeScript("return (" + getText + ")(arguments[0]);", new Object[]{locator});
        }
        catch (WebDriverException e) {
            WebElement element = this.finder.findElement(driver, locator);
            return element.getText();
        }
    }
}

