/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.graphics.Bitmap;
import android.os.Message;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.android.library.DriverProvider;
import org.openqa.selenium.android.library.ViewAdapter;
import org.openqa.selenium.android.library.ViewProvider;
import org.openqa.selenium.android.library.WebDriverChromeClient;
import org.openqa.selenium.android.library.WebDriverView;

public class DefaultChromeClient
extends WebChromeClient
implements DriverProvider,
ViewProvider {
    private final WebChromeClient delegate;
    private WebDriverView wdView;
    private WebDriverChromeClient wdChromeClient;

    public DefaultChromeClient() {
        this(null);
    }

    public DefaultChromeClient(WebChromeClient client) {
        this.delegate = client == null ? new WebChromeClient() : client;
    }

    @Override
    public void setDriver(AndroidWebDriver driver) {
        this.wdChromeClient = new WebDriverChromeClient(driver);
    }

    @Override
    public void setWebDriverView(WebDriverView view) {
        this.wdView = view;
    }

    public void onCloseWindow(WebView window) {
        this.wdChromeClient.onCloseWindow(window);
        this.delegate.onCloseWindow(window);
    }

    public boolean onCreateWindow(WebView view, boolean dialog, boolean userGesture, Message resultMsg) {
        ViewAdapter newView = this.wdView.create();
        WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
        transport.setWebView((WebView)newView.getUnderlyingView());
        resultMsg.sendToTarget();
        this.wdChromeClient.onCreateWindow(newView);
        return this.delegate.onCreateWindow(view, dialog, userGesture, resultMsg);
    }

    public void onRequestFocus(WebView view) {
        this.delegate.onRequestFocus(view);
    }

    public void onProgressChanged(WebView view, int newProgress) {
        this.wdChromeClient.onProgressChanged(view, newProgress);
        this.delegate.onProgressChanged(view, newProgress);
    }

    public void onReceivedTitle(WebView view, String title) {
        this.delegate.onReceivedTitle(view, title);
    }

    public void onReceivedIcon(WebView view, Bitmap icon) {
        this.delegate.onReceivedIcon(view, icon);
    }

    public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
        this.delegate.onReceivedTouchIconUrl(view, url, precomposed);
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        this.delegate.onShowCustomView(view, callback);
    }

    public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
        this.delegate.onShowCustomView(view, requestedOrientation, callback);
    }

    public void onHideCustomView() {
        this.delegate.onHideCustomView();
    }

    public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
        this.wdChromeClient.onJsAlert(view, message, result);
        return this.delegate.onJsAlert(view, url, message, result);
    }

    public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
        this.wdChromeClient.onJsConfirm(view, message, result);
        return this.delegate.onJsConfirm(view, url, message, result);
    }

    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        this.wdChromeClient.onJsPrompt(view, message, defaultValue, result);
        return this.delegate.onJsPrompt(view, url, message, defaultValue, result);
    }

    public boolean onJsBeforeUnload(WebView view, String url, String message, JsResult result) {
        return super.onJsBeforeUnload(view, url, message, result);
    }

    public void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        this.delegate.onExceededDatabaseQuota(url, databaseIdentifier, currentQuota, estimatedSize, totalUsedQuota, quotaUpdater);
    }

    public void onReachedMaxAppCacheSize(long spaceNeeded, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        this.delegate.onReachedMaxAppCacheSize(spaceNeeded, totalUsedQuota, quotaUpdater);
    }

    public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        this.wdChromeClient.onGeolocationPermissionsShowPrompt(origin, callback);
        this.delegate.onGeolocationPermissionsShowPrompt(origin, callback);
    }

    public void onGeolocationPermissionsHidePrompt() {
        this.delegate.onGeolocationPermissionsHidePrompt();
    }

    public boolean onJsTimeout() {
        return this.delegate.onJsTimeout();
    }

    public void onConsoleMessage(String message, int lineNumber, String sourceID) {
        this.delegate.onConsoleMessage(message, lineNumber, sourceID);
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        return this.delegate.onConsoleMessage(consoleMessage);
    }

    public Bitmap getDefaultVideoPoster() {
        return this.delegate.getDefaultVideoPoster();
    }

    public View getVideoLoadingProgressView() {
        return this.delegate.getVideoLoadingProgressView();
    }

    public void getVisitedHistory(ValueCallback<String[]> callback) {
        this.delegate.getVisitedHistory(callback);
    }
}

