/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.monitoring;

import java.io.InputStream;
import java.util.Base64;
import nl.surfnet.coin.monitoring.AbstractMonitor;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class PdPMonitor
extends AbstractMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(PdPMonitor.class);

    public static void main(String[] args) throws Exception {
        PdPMonitor pdPMonitor = new PdPMonitor();
        if (args.length == 4) {
            pdPMonitor.doMonitor(args[0], args[1], args[2], args[3], args[4]);
        } else {
            pdPMonitor.monitor();
        }
    }

    public void monitor() {
        String conextDomain = this.getProperty("conextDomain");
        String userName = this.getProperty("pdpUserName");
        String password = this.getProperty("pdpPassword");
        String idpEntityId = this.getProperty("idpEntityId");
        String spEntityId = this.getProperty("spEntityId");
        this.doMonitor(conextDomain, userName, password, idpEntityId, spEntityId);
    }

    public void doMonitor(String conextDomain, String userName, String password, String idpEntityId, String spEntityId) {
        try {
            RestTemplate restTemplate = new RestTemplate();
            String body = IOUtils.toString((InputStream)new ClassPathResource("pdp/request.json").getInputStream());
            body = body.replaceAll("@@IDP_ENTITY_ID@@", idpEntityId);
            body = body.replaceAll("@@SP_ENTITY_ID@@", spEntityId);
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/json");
            headers.add("Authorization", "Basic " + Base64.getEncoder().encodeToString(new String(userName + ":" + password).getBytes()));
            HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            String url = "https://pdp." + conextDomain + "/pdp/api/decide/policy";
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode().value());
            Assert.assertTrue((boolean)((String)response.getBody()).contains("urn:oasis:names:tc:xacml:1.0:status:ok"));
            Assert.assertTrue((boolean)((String)response.getBody()).contains("NotApplicable"));
        }
        catch (Throwable e) {
            LOG.error("Exception while running PdPMonitor, will exit(2)", e);
            System.exit(2);
        }
    }
}

