/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.pagefactory;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByAll
extends By {
    private By[] bys;

    public ByAll(By ... bys) {
        this.bys = bys;
    }

    public WebElement findElement(SearchContext context) {
        List<WebElement> elements = this.findElements(context);
        if (elements.isEmpty()) {
            throw new NoSuchElementException("Cannot locate an element using " + this.toString());
        }
        return elements.get(0);
    }

    public List<WebElement> findElements(SearchContext context) {
        ArrayList<WebElement> elems = new ArrayList<WebElement>();
        for (By by : this.bys) {
            elems.addAll(by.findElements(context));
        }
        return elems;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("By.all(");
        stringBuilder.append("{");
        boolean first = true;
        for (By by : this.bys) {
            stringBuilder.append(first ? "" : ",").append(by);
            first = false;
        }
        stringBuilder.append("})");
        return stringBuilder.toString();
    }
}

