/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.OnbeforeunloadHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCDataSection;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomDocumentType;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlBase;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrame;
import com.gargoylesoftware.htmlunit.html.HtmlFrameSet;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlLegend;
import com.gargoylesoftware.htmlunit.html.HtmlMeta;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.XPathDomNodeList;
import com.gargoylesoftware.htmlunit.html.XmlSerializer;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;

public class HtmlPage
extends SgmlPage {
    private static final Log LOG = LogFactory.getLog(HtmlPage.class);
    private HTMLParser.HtmlUnitDOMBuilder builder_;
    private String originalCharset_;
    private Map<String, List<DomElement>> idMap_ = new HashMap<String, List<DomElement>>();
    private Map<String, List<DomElement>> nameMap_ = new HashMap<String, List<DomElement>>();
    private HtmlElement elementWithFocus_;
    private int parserCount_;
    private int snippetParserCount_;
    private int inlineSnippetParserCount_;
    private List<HtmlAttributeChangeListener> attributeListeners_;
    private final Object lock_ = new String();
    private final List<Range> selectionRanges_ = new ArrayList<Range>(3);
    private final List<PostponedAction> afterLoadActions_ = new ArrayList<PostponedAction>();
    private boolean cleaning_;
    private HtmlBase base_;
    private URL baseUrl_;

    public HtmlPage(URL originatingUrl, WebResponse webResponse, WebWindow webWindow) {
        super(webResponse, webWindow);
    }

    @Override
    public HtmlPage getPage() {
        return this;
    }

    @Override
    public boolean hasCaseSensitiveTagNames() {
        return false;
    }

    @Override
    public void initialize() throws IOException, FailingHttpStatusCodeException {
        boolean isAboutBlank;
        WebWindow enclosingWindow = this.getEnclosingWindow();
        boolean bl = isAboutBlank = this.getUrl() == WebClient.URL_ABOUT_BLANK;
        if (isAboutBlank) {
            TopLevelWindow topWindow;
            WebWindow openerWindow;
            if (enclosingWindow instanceof FrameWindow && !((FrameWindow)enclosingWindow).getFrameElement().isContentLoaded()) {
                return;
            }
            if (enclosingWindow instanceof TopLevelWindow && (openerWindow = (topWindow = (TopLevelWindow)enclosingWindow).getOpener()) != null && openerWindow.getEnclosedPage() != null) {
                this.baseUrl_ = openerWindow.getEnclosedPage().getWebResponse().getWebRequest().getUrl();
            }
        }
        this.loadFrames();
        BrowserVersion browserVersion = this.getWebClient().getBrowserVersion();
        if (!isAboutBlank) {
            if (browserVersion.hasFeature(BrowserVersionFeatures.FOCUS_HTML_ELEMENT_AT_START)) {
                this.elementWithFocus_ = this.getDocumentElement();
            }
            this.setReadyState("complete");
            this.getDocumentElement().setReadyState("complete");
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.EVENT_DOM_CONTENT_LOADED)) {
            this.executeEventHandlersIfNeeded("DOMContentLoaded");
        }
        this.executeDeferredScriptsIfNeeded();
        this.setReadyStateOnDeferredScriptsIfNeeded();
        boolean framesetFirst = browserVersion.hasFeature(BrowserVersionFeatures.EVENT_ONLOAD_FRAMESET_FIRST);
        boolean isFrameWindow = enclosingWindow instanceof FrameWindow;
        boolean isFirstPageInFrameWindow = false;
        if (isFrameWindow) {
            isFrameWindow = ((FrameWindow)enclosingWindow).getFrameElement() instanceof HtmlFrame;
            boolean bl2 = isFirstPageInFrameWindow = enclosingWindow.getHistory().getLength() <= 2;
        }
        if (framesetFirst && !isFrameWindow || isFrameWindow && !isFirstPageInFrameWindow) {
            this.executeEventHandlersIfNeeded("load");
        }
        for (FrameWindow frameWindow : this.getFrames()) {
            Page page;
            if (!(frameWindow.getFrameElement() instanceof HtmlFrame) || !((page = frameWindow.getEnclosedPage()) instanceof HtmlPage)) continue;
            ((HtmlPage)page).executeEventHandlersIfNeeded("load");
        }
        if (!framesetFirst && !isFrameWindow) {
            this.executeEventHandlersIfNeeded("load");
        }
        ArrayList<PostponedAction> actions = new ArrayList<PostponedAction>(this.afterLoadActions_);
        this.afterLoadActions_.clear();
        try {
            for (PostponedAction action : actions) {
                action.execute();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.executeRefreshIfNeeded();
    }

    void addAfterLoadAction(PostponedAction action) {
        this.afterLoadActions_.add(action);
    }

    @Override
    public void cleanUp() {
        if (this.cleaning_) {
            return;
        }
        this.cleaning_ = true;
        super.cleanUp();
        this.executeEventHandlersIfNeeded("unload");
        this.deregisterFramesIfNeeded();
        this.cleaning_ = false;
    }

    @Override
    public HtmlElement getDocumentElement() {
        return (HtmlElement)super.getDocumentElement();
    }

    public HtmlElement getBody() {
        HtmlElement doc = this.getDocumentElement();
        if (doc != null) {
            for (DomNode node : doc.getChildren()) {
                if (!(node instanceof HtmlBody) && !(node instanceof HtmlFrameSet)) continue;
                return (HtmlElement)node;
            }
        }
        return null;
    }

    public HtmlElement getHead() {
        HtmlElement doc = this.getDocumentElement();
        if (doc != null) {
            for (DomNode node : doc.getChildren()) {
                if (!(node instanceof HtmlHead)) continue;
                return (HtmlElement)node;
            }
        }
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public org.w3c.dom.Node importNode(org.w3c.dom.Node importedNode, boolean deep) {
        throw new UnsupportedOperationException("HtmlPage.importNode is not yet implemented.");
    }

    @Override
    public DomNodeList<DomElement> getElementsByTagName(String tagName) {
        return new XPathDomNodeList<DomElement>(this, "//*[local-name()='" + tagName + "']");
    }

    @Override
    public DomNodeList<DomElement> getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("HtmlPage.getElementsByTagNameNS is not yet implemented.");
    }

    @Override
    public DomElement getElementById(String elementId) {
        try {
            return this.getElementById(elementId, true);
        }
        catch (ElementNotFoundException e) {
            return null;
        }
    }

    @Override
    public String getInputEncoding() {
        throw new UnsupportedOperationException("HtmlPage.getInputEncoding is not yet implemented.");
    }

    @Override
    public String getXmlEncoding() {
        throw new UnsupportedOperationException("HtmlPage.getXmlEncoding is not yet implemented.");
    }

    @Override
    public boolean getXmlStandalone() {
        throw new UnsupportedOperationException("HtmlPage.getXmlStandalone is not yet implemented.");
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.setXmlStandalone is not yet implemented.");
    }

    @Override
    public String getXmlVersion() {
        throw new UnsupportedOperationException("HtmlPage.getXmlVersion is not yet implemented.");
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.setXmlVersion is not yet implemented.");
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("HtmlPage.getStrictErrorChecking is not yet implemented.");
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException("HtmlPage.setStrictErrorChecking is not yet implemented.");
    }

    @Override
    public String getDocumentURI() {
        throw new UnsupportedOperationException("HtmlPage.getDocumentURI is not yet implemented.");
    }

    @Override
    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException("HtmlPage.setDocumentURI is not yet implemented.");
    }

    @Override
    public org.w3c.dom.Node adoptNode(org.w3c.dom.Node source) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.adoptNode is not yet implemented.");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException("HtmlPage.getDomConfig is not yet implemented.");
    }

    @Override
    public org.w3c.dom.Node renameNode(org.w3c.dom.Node newNode, String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.renameNode is not yet implemented.");
    }

    @Override
    public String getPageEncoding() {
        if (this.originalCharset_ == null) {
            this.originalCharset_ = this.getWebResponse().getContentCharset();
        }
        return this.originalCharset_;
    }

    @Override
    public DomElement createElement(String tagName) {
        if (tagName.indexOf(58) == -1) {
            tagName = tagName.toLowerCase();
        }
        return HTMLParser.getFactory(tagName).createElementNS(this, null, tagName, null, true);
    }

    @Override
    public DomElement createElementNS(String namespaceURI, String qualifiedName) {
        return HTMLParser.getElementFactory(this, namespaceURI, qualifiedName).createElementNS(this, namespaceURI, qualifiedName, null, true);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("HtmlPage.createAttributeNS is not yet implemented.");
    }

    @Override
    public Comment createComment(String data) {
        return new DomComment(this, data);
    }

    @Override
    public Text createTextNode(String data) {
        return new DomText(this, data);
    }

    @Override
    public CDATASection createCDATASection(String data) {
        return new DomCDataSection(this, data);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new DomDocumentFragment(this);
    }

    @Override
    public DOMImplementation getImplementation() {
        throw new UnsupportedOperationException("HtmlPage.getImplementation is not yet implemented.");
    }

    @Override
    public EntityReference createEntityReference(String id) {
        throw new UnsupportedOperationException("HtmlPage.createEntityReference is not yet implemented.");
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("HtmlPage.createProcessingInstruction is not yet implemented.");
    }

    public HtmlAnchor getAnchorByName(String name) throws ElementNotFoundException {
        return (HtmlAnchor)this.getDocumentElement().getOneHtmlElementByAttribute("a", "name", name);
    }

    public HtmlAnchor getAnchorByHref(String href) throws ElementNotFoundException {
        return (HtmlAnchor)this.getDocumentElement().getOneHtmlElementByAttribute("a", "href", href);
    }

    public List<HtmlAnchor> getAnchors() {
        return this.getDocumentElement().getHtmlElementsByTagName("a");
    }

    public HtmlAnchor getAnchorByText(String text) throws ElementNotFoundException {
        WebAssert.notNull("text", text);
        for (HtmlAnchor anchor : this.getAnchors()) {
            if (!text.equals(anchor.asText())) continue;
            return anchor;
        }
        throw new ElementNotFoundException("a", "<text>", text);
    }

    public HtmlForm getFormByName(String name) throws ElementNotFoundException {
        List forms = this.getDocumentElement().getElementsByAttribute("form", "name", name);
        if (forms.size() == 0) {
            throw new ElementNotFoundException("form", "name", name);
        }
        return (HtmlForm)forms.get(0);
    }

    public List<HtmlForm> getForms() {
        return this.getDocumentElement().getHtmlElementsByTagName("form");
    }

    public URL getFullyQualifiedUrl(String relativeUrl) throws MalformedURLException {
        URL baseUrl;
        if (this.base_ == null) {
            boolean frame;
            baseUrl = this.getUrl();
            WebWindow window = this.getEnclosingWindow();
            boolean bl = frame = window != window.getTopWindow();
            if (frame) {
                boolean frameSrcIsNotSet = baseUrl == WebClient.URL_ABOUT_BLANK;
                boolean frameSrcIsJs = "javascript".equals(baseUrl.getProtocol());
                boolean jsFrameUseParentUrl = this.hasFeature(BrowserVersionFeatures.JS_FRAME_RESOLVE_URL_WITH_PARENT_WINDOW);
                if (frameSrcIsNotSet || frameSrcIsJs && jsFrameUseParentUrl) {
                    baseUrl = ((HtmlPage)window.getTopWindow().getEnclosedPage()).getWebResponse().getWebRequest().getUrl();
                }
            } else if (this.baseUrl_ != null) {
                baseUrl = this.baseUrl_;
            }
        } else {
            boolean insideHead = false;
            for (DomNode parent = this.base_.getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (!(parent instanceof HtmlHead)) continue;
                insideHead = true;
                break;
            }
            if (!insideHead) {
                this.notifyIncorrectness("Element 'base' must appear in <head>, it is ignored.");
            }
            String href = this.base_.getHrefAttribute();
            if (!insideHead || StringUtils.isEmpty((CharSequence)href)) {
                baseUrl = this.getUrl();
            } else {
                try {
                    baseUrl = new URL(href);
                }
                catch (MalformedURLException e) {
                    this.notifyIncorrectness("Invalid base url: \"" + href + "\", ignoring it");
                    baseUrl = this.getUrl();
                }
            }
        }
        if (this.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_MISSING_SLASHES)) {
            boolean incorrectnessNotified = false;
            while (relativeUrl.startsWith("http:") && !relativeUrl.startsWith("http://")) {
                if (!incorrectnessNotified) {
                    this.notifyIncorrectness("Incorrect URL \"" + relativeUrl + "\" has been corrected");
                    incorrectnessNotified = true;
                }
                relativeUrl = "http:/" + relativeUrl.substring(5);
            }
        }
        return WebClient.expandUrl(baseUrl, relativeUrl);
    }

    public String getResolvedTarget(String elementTarget) {
        String resolvedTarget = this.base_ == null ? elementTarget : (elementTarget != null && elementTarget.length() > 0 ? elementTarget : this.base_.getTargetAttribute());
        return resolvedTarget;
    }

    public List<String> getTabbableElementIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (HtmlElement element : this.getTabbableElements()) {
            list.add(element.getAttribute("id"));
        }
        return Collections.unmodifiableList(list);
    }

    public List<HtmlElement> getTabbableElements() {
        List<String> tags = Arrays.asList("a", "area", "button", "input", "object", "select", "textarea");
        ArrayList<HtmlElement> tabbableElements = new ArrayList<HtmlElement>();
        for (HtmlElement element : this.getHtmlElementDescendants()) {
            boolean disabled;
            String tagName = element.getTagName();
            if (!tags.contains(tagName) || (disabled = element.hasAttribute("disabled")) || element.getTabIndex() == HtmlElement.TAB_INDEX_OUT_OF_BOUNDS) continue;
            tabbableElements.add(element);
        }
        Collections.sort(tabbableElements, this.createTabOrderComparator());
        return Collections.unmodifiableList(tabbableElements);
    }

    private Comparator<HtmlElement> createTabOrderComparator() {
        return new Comparator<HtmlElement>(){

            @Override
            public int compare(HtmlElement element1, HtmlElement element2) {
                Short i1 = element1.getTabIndex();
                Short i2 = element2.getTabIndex();
                int index1 = i1 != null ? (int)i1.shortValue() : -1;
                int index2 = i2 != null ? (int)i2.shortValue() : -1;
                int result = index1 > 0 && index2 > 0 ? index1 - index2 : (index1 > 0 ? -1 : (index2 > 0 ? 1 : (index1 == index2 ? 0 : index2 - index1)));
                return result;
            }
        };
    }

    @Deprecated
    public HtmlElement getElementByAccessKey(char accessKey) {
        return this.getHtmlElementByAccessKey(accessKey);
    }

    public HtmlElement getHtmlElementByAccessKey(char accessKey) {
        List<HtmlElement> elements = this.getElementsByAccessKey(accessKey);
        if (elements.isEmpty()) {
            return null;
        }
        return elements.get(0);
    }

    @Deprecated
    public List<HtmlElement> getElementsByAccessKey(char accessKey) {
        return this.getHtmlElementsByAccessKey(accessKey);
    }

    public List<HtmlElement> getHtmlElementsByAccessKey(char accessKey) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        String searchString = Character.toString(accessKey).toLowerCase();
        List<String> acceptableTagNames = Arrays.asList("a", "area", "button", "input", "label", "legend", "textarea");
        for (HtmlElement element : this.getHtmlElementDescendants()) {
            String accessKeyAttribute;
            if (!acceptableTagNames.contains(element.getTagName()) || !searchString.equalsIgnoreCase(accessKeyAttribute = element.getAttribute("accesskey"))) continue;
            elements.add(element);
        }
        return elements;
    }

    public ScriptResult executeJavaScript(String sourceCode) {
        return this.executeJavaScriptIfPossible(sourceCode, "injected script", 1);
    }

    public ScriptResult executeJavaScriptIfPossible(String sourceCode, String sourceName, int startLine) {
        if (!this.getWebClient().getOptions().isJavaScriptEnabled()) {
            return new ScriptResult(null, this);
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)sourceCode, (CharSequence)"javascript:")) {
            sourceCode = sourceCode.substring("javascript:".length());
        }
        Object result = this.getWebClient().getJavaScriptEngine().execute(this, sourceCode, sourceName, startLine);
        return new ScriptResult(result, this.getWebClient().getCurrentWindow().getEnclosedPage());
    }

    public ScriptResult executeJavaScriptFunctionIfPossible(Function function, Scriptable thisObject, Object[] args, DomNode htmlElementScope) {
        if (!this.getWebClient().getOptions().isJavaScriptEnabled()) {
            return new ScriptResult(null, this);
        }
        JavaScriptEngine engine = this.getWebClient().getJavaScriptEngine();
        Object result = engine.callFunction(this, function, thisObject, args, htmlElementScope);
        return new ScriptResult(result, this.getWebClient().getCurrentWindow().getEnclosedPage());
    }

    JavaScriptLoadResult loadExternalJavaScriptFile(String srcAttribute, String charset) throws FailingHttpStatusCodeException {
        Script script;
        URL scriptURL;
        WebClient client = this.getWebClient();
        if (StringUtils.isBlank((CharSequence)srcAttribute) || !client.getOptions().isJavaScriptEnabled()) {
            return JavaScriptLoadResult.NOOP;
        }
        try {
            scriptURL = this.getFullyQualifiedUrl(srcAttribute);
            if ("javascript".equals(scriptURL.getProtocol())) {
                LOG.info((Object)("Ignoring script src [" + srcAttribute + "]"));
                return JavaScriptLoadResult.NOOP;
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Unable to build URL for script src tag [" + srcAttribute + "]"));
            JavaScriptErrorListener javaScriptErrorListener = client.getJavaScriptErrorListener();
            if (javaScriptErrorListener != null) {
                javaScriptErrorListener.malformedScriptURL(this, srcAttribute, e);
            }
            return JavaScriptLoadResult.NOOP;
        }
        try {
            script = this.loadJavaScriptFromUrl(scriptURL, charset);
        }
        catch (IOException e) {
            LOG.error((Object)("Error loading JavaScript from [" + scriptURL + "]."), (Throwable)e);
            JavaScriptErrorListener javaScriptErrorListener = client.getJavaScriptErrorListener();
            if (javaScriptErrorListener != null) {
                javaScriptErrorListener.loadScriptError(this, scriptURL, e);
            }
            return JavaScriptLoadResult.DOWNLOAD_ERROR;
        }
        catch (FailingHttpStatusCodeException e) {
            LOG.error((Object)("Error loading JavaScript from [" + scriptURL + "]."), (Throwable)e);
            JavaScriptErrorListener javaScriptErrorListener = client.getJavaScriptErrorListener();
            if (javaScriptErrorListener != null) {
                javaScriptErrorListener.loadScriptError(this, scriptURL, e);
            }
            throw e;
        }
        if (script == null) {
            return JavaScriptLoadResult.COMPILATION_ERROR;
        }
        client.getJavaScriptEngine().execute(this, script);
        return JavaScriptLoadResult.SUCCESS;
    }

    private Script loadJavaScriptFromUrl(URL url, String charset) throws IOException, FailingHttpStatusCodeException {
        String scriptCode;
        boolean noContent;
        String scriptEncoding = charset;
        String pageEncoding = this.getPageEncoding();
        WebRequest referringRequest = this.getWebResponse().getWebRequest();
        WebClient client = this.getWebClient();
        Cache cache = client.getCache();
        WebRequest request = new WebRequest(url);
        request.setAdditionalHeaders(new HashMap<String, String>(referringRequest.getAdditionalHeaders()));
        request.setAdditionalHeader("Referer", referringRequest.getUrl().toString());
        Object cachedScript = cache.getCachedObject(request);
        if (cachedScript instanceof Script) {
            return (Script)cachedScript;
        }
        WebResponse response = client.loadWebResponse(request);
        client.printContentIfNecessary(response);
        client.throwFailingHttpStatusCodeExceptionIfNecessary(response);
        int statusCode = response.getStatusCode();
        boolean successful = statusCode >= 200 && statusCode < 300;
        boolean bl = noContent = statusCode == 204;
        if (!successful || noContent) {
            throw new IOException("Unable to download JavaScript from '" + url + "' (status " + statusCode + ").");
        }
        String contentType = response.getContentType();
        if (!"application/javascript".equalsIgnoreCase(contentType) && !"application/ecmascript".equalsIgnoreCase(contentType)) {
            if ("text/javascript".equals(contentType) || "text/ecmascript".equals(contentType) || "application/x-javascript".equalsIgnoreCase(contentType)) {
                this.getWebClient().getIncorrectnessListener().notify("Obsolete content type encountered: '" + contentType + "'.", this);
            } else {
                this.getWebClient().getIncorrectnessListener().notify("Expected content type of 'application/javascript' or 'application/ecmascript' for remotely loaded JavaScript element at '" + url + "', " + "but got '" + contentType + "'.", this);
            }
        }
        if (StringUtils.isEmpty((CharSequence)scriptEncoding)) {
            String contentCharset = response.getContentCharset();
            scriptEncoding = !contentCharset.equals("ISO-8859-1") ? contentCharset : (!pageEncoding.equals("ISO-8859-1") ? pageEncoding : "ISO-8859-1");
        }
        if (null != (scriptCode = response.getContentAsString(scriptEncoding))) {
            JavaScriptEngine javaScriptEngine = client.getJavaScriptEngine();
            Script script = javaScriptEngine.compile(this, scriptCode, url.toExternalForm(), 1);
            if (script != null) {
                cache.cacheIfPossible(request, response, script);
            }
            return script;
        }
        return null;
    }

    public String getTitleText() {
        HtmlTitle titleElement = this.getTitleElement();
        if (titleElement != null) {
            return titleElement.asText();
        }
        return "";
    }

    public void setTitleText(String message) {
        HtmlTitle titleElement = this.getTitleElement();
        if (titleElement == null) {
            HtmlHead head;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No title element, creating one");
            }
            if ((head = (HtmlHead)this.getFirstChildElement(this.getDocumentElement(), HtmlHead.class)) == null) {
                throw new IllegalStateException("Headelement was not defined for this page");
            }
            Map<String, DomAttr> emptyMap = Collections.emptyMap();
            titleElement = new HtmlTitle(null, "title", this, emptyMap);
            if (head.getFirstChild() != null) {
                head.getFirstChild().insertBefore(titleElement);
            } else {
                head.appendChild(titleElement);
            }
        }
        titleElement.setNodeValue(message);
    }

    private DomElement getFirstChildElement(DomElement startElement, Class<?> clazz) {
        if (startElement == null) {
            return null;
        }
        for (DomElement element : startElement.getChildElements()) {
            if (!clazz.isInstance(element)) continue;
            return element;
        }
        return null;
    }

    private HtmlTitle getTitleElement() {
        HtmlHead head = (HtmlHead)this.getFirstChildElement(this.getDocumentElement(), HtmlHead.class);
        if (head != null) {
            return (HtmlTitle)this.getFirstChildElement(head, HtmlTitle.class);
        }
        return null;
    }

    private boolean executeEventHandlersIfNeeded(String eventType) {
        if (!this.getWebClient().getOptions().isJavaScriptEnabled()) {
            return true;
        }
        WebWindow window = this.getEnclosingWindow();
        Window jsWindow = (Window)window.getScriptObject();
        if (jsWindow != null) {
            HtmlElement element = this.getDocumentElement();
            if (element == null) {
                return true;
            }
            Event event = new Event(element, eventType);
            element.fireEvent(event);
            if (!this.isOnbeforeunloadAccepted(this, event)) {
                return false;
            }
        }
        if (window instanceof FrameWindow) {
            BaseFrameElement frame;
            if ("load".equals(eventType) && !this.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONLOAD_IFRAME_CREATED_BY_JAVASCRIPT) && (frame = ((FrameWindow)window).getFrameElement()).wasCreatedByJavascript()) {
                frame.unmarkAsCreatedByJavascript();
                return true;
            }
            FrameWindow fw = (FrameWindow)window;
            BaseFrameElement frame2 = fw.getFrameElement();
            if ("load".equals(eventType) && frame2.getParentNode() instanceof DomDocumentFragment) {
                return true;
            }
            if (frame2.hasEventHandlers("on" + eventType)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Executing on" + eventType + " handler for " + frame2));
                }
                Event event = new Event(frame2, eventType);
                ((Node)frame2.getScriptObject()).executeEvent(event);
                if (!this.isOnbeforeunloadAccepted((HtmlPage)frame2.getPage(), event)) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isOnbeforeunloadAccepted(HtmlPage page, Event event) {
        if (event.getType().equals("beforeunload") && event.getReturnValue() != null) {
            OnbeforeunloadHandler handler = this.getWebClient().getOnbeforeunloadHandler();
            if (handler == null) {
                LOG.warn((Object)"document.onbeforeunload() returned a string in event.returnValue, but no onbeforeunload handler installed.");
            } else {
                String message = Context.toString((Object)event.getReturnValue());
                return handler.handleEvent(page, message);
            }
        }
        return true;
    }

    private void executeRefreshIfNeeded() throws IOException {
        URL url;
        double time;
        boolean timeOnly;
        WebWindow window = this.getEnclosingWindow();
        if (window == null) {
            return;
        }
        String refreshString = this.getRefreshStringOrNull();
        if (refreshString == null || refreshString.isEmpty()) {
            return;
        }
        int index = StringUtils.indexOfAnyBut((CharSequence)refreshString, (CharSequence)"0123456789");
        boolean bl = timeOnly = index == -1;
        if (timeOnly) {
            try {
                time = Double.parseDouble(refreshString);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Malformed refresh string (no ';' but not a number): " + refreshString), (Throwable)e);
                return;
            }
            url = this.getUrl();
        } else {
            try {
                time = Double.parseDouble(refreshString.substring(0, index).trim());
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Malformed refresh string (no valid number before ';') " + refreshString), (Throwable)e);
                return;
            }
            index = refreshString.toLowerCase().indexOf("url=", index);
            if (index == -1) {
                LOG.error((Object)("Malformed refresh string (found ';' but no 'url='): " + refreshString));
                return;
            }
            StringBuilder buffer = new StringBuilder(refreshString.substring(index + 4));
            if (StringUtils.isBlank((CharSequence)buffer.toString())) {
                url = this.getUrl();
            } else {
                if (buffer.charAt(0) == '\"' || buffer.charAt(0) == '\'') {
                    buffer.deleteCharAt(0);
                }
                if (buffer.charAt(buffer.length() - 1) == '\"' || buffer.charAt(buffer.length() - 1) == '\'') {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                String urlString = buffer.toString();
                try {
                    url = this.getFullyQualifiedUrl(urlString);
                }
                catch (MalformedURLException e) {
                    LOG.error((Object)("Malformed URL in refresh string: " + refreshString), (Throwable)e);
                    throw e;
                }
            }
        }
        int timeRounded = (int)time;
        this.getWebClient().getRefreshHandler().handleRefresh(this, url, timeRounded);
    }

    private String getRefreshStringOrNull() {
        Iterator<HtmlMeta> i$ = this.getMetaTags("refresh").iterator();
        if (i$.hasNext()) {
            HtmlMeta meta = i$.next();
            return meta.getContentAttribute().trim();
        }
        return this.getWebResponse().getResponseHeaderValue("Refresh");
    }

    private void executeDeferredScriptsIfNeeded() {
        if (!this.getWebClient().getOptions().isJavaScriptEnabled()) {
            return;
        }
        if (this.hasFeature(BrowserVersionFeatures.JS_DEFERRED)) {
            HtmlElement doc = this.getDocumentElement();
            List elements = doc.getHtmlElementsByTagName("script");
            for (HtmlElement e : elements) {
                HtmlScript script;
                if (!(e instanceof HtmlScript) || !(script = (HtmlScript)e).isDeferred()) continue;
                script.executeScriptIfNeeded();
            }
        }
    }

    private void setReadyStateOnDeferredScriptsIfNeeded() {
        if (this.getWebClient().getOptions().isJavaScriptEnabled() && this.hasFeature(BrowserVersionFeatures.JS_DEFERRED)) {
            List elements = this.getDocumentElement().getHtmlElementsByTagName("script");
            for (HtmlElement e : elements) {
                HtmlScript script;
                if (!(e instanceof HtmlScript) || !(script = (HtmlScript)e).isDeferred()) continue;
                script.setAndExecuteReadyState("complete");
            }
        }
    }

    public void deregisterFramesIfNeeded() {
        for (WebWindow webWindow : this.getFrames()) {
            HtmlPage page;
            this.getWebClient().deregisterWebWindow(webWindow);
            if (!(webWindow.getEnclosedPage() instanceof HtmlPage) || (page = (HtmlPage)webWindow.getEnclosedPage()) == null) continue;
            page.deregisterFramesIfNeeded();
        }
    }

    public List<FrameWindow> getFrames() {
        ArrayList<FrameWindow> list = new ArrayList<FrameWindow>();
        WebWindow enclosingWindow = this.getEnclosingWindow();
        for (WebWindow window : this.getWebClient().getWebWindows()) {
            if (enclosingWindow != window.getParentWindow() || enclosingWindow == window) continue;
            list.add((FrameWindow)window);
        }
        return list;
    }

    public FrameWindow getFrameByName(String name) throws ElementNotFoundException {
        for (FrameWindow frame : this.getFrames()) {
            if (!frame.getName().equals(name)) continue;
            return frame;
        }
        throw new ElementNotFoundException("frame or iframe", "name", name);
    }

    public HtmlElement pressAccessKey(char accessKey) throws IOException {
        HtmlElement element = this.getElementByAccessKey(accessKey);
        if (element != null) {
            element.focus();
            Object newPage = element instanceof HtmlAnchor ? ((HtmlAnchor)element).click() : (element instanceof HtmlArea ? ((HtmlArea)element).click() : (element instanceof HtmlButton ? ((HtmlButton)element).click() : (element instanceof HtmlInput ? ((HtmlInput)element).click() : (element instanceof HtmlLabel ? ((HtmlLabel)element).click() : (element instanceof HtmlLegend ? ((HtmlLegend)element).click() : (element instanceof HtmlTextArea ? ((HtmlTextArea)element).click() : this))))));
            if (newPage != this && this.getFocusedElement() == element) {
                this.getFocusedElement().blur();
            }
        }
        return this.getFocusedElement();
    }

    public HtmlElement tabToNextElement() {
        int index;
        List<HtmlElement> elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.setFocusedElement(null);
            return null;
        }
        HtmlElement elementWithFocus = this.getFocusedElement();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? elements.get(0) : ((index = elements.indexOf(elementWithFocus)) == -1 ? elements.get(0) : (index == elements.size() - 1 ? elements.get(0) : elements.get(index + 1)));
        this.setFocusedElement(elementToGiveFocus);
        return elementToGiveFocus;
    }

    public HtmlElement tabToPreviousElement() {
        int index;
        List<HtmlElement> elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.setFocusedElement(null);
            return null;
        }
        HtmlElement elementWithFocus = this.getFocusedElement();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? elements.get(elements.size() - 1) : ((index = elements.indexOf(elementWithFocus)) == -1 ? elements.get(elements.size() - 1) : (index == 0 ? elements.get(elements.size() - 1) : elements.get(index - 1)));
        this.setFocusedElement(elementToGiveFocus);
        return elementToGiveFocus;
    }

    public <E extends HtmlElement> E getHtmlElementById(String id) throws ElementNotFoundException {
        return (E)((HtmlElement)this.getElementById(id, true));
    }

    public <E extends HtmlElement> E getHtmlElementById(String id, boolean caseSensitive) throws ElementNotFoundException {
        return (E)((HtmlElement)this.getElementById(id, caseSensitive));
    }

    public <E extends DomElement> E getElementById(String id, boolean caseSensitive) throws ElementNotFoundException {
        List<DomElement> elements = this.idMap_.get(id);
        if (null == elements && !caseSensitive) {
            for (String key : this.idMap_.keySet()) {
                if (!key.equalsIgnoreCase(id)) continue;
                elements = this.idMap_.get(key);
                break;
            }
        }
        if (elements != null) {
            return (E)elements.get(0);
        }
        throw new ElementNotFoundException("*", "id", id);
    }

    public <E extends DomElement> E getElementByName(String name) throws ElementNotFoundException {
        List<DomElement> elements = this.nameMap_.get(name);
        if (elements != null) {
            return (E)elements.get(0);
        }
        throw new ElementNotFoundException("*", "name", name);
    }

    public List<DomElement> getElementsByName(String name) {
        List<DomElement> list = this.nameMap_.get(name);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public List<DomElement> getElementsByIdAndOrName(String idAndOrName) {
        List<DomElement> list1 = this.idMap_.get(idAndOrName);
        List<DomElement> list2 = this.nameMap_.get(idAndOrName);
        ArrayList<DomElement> list = new ArrayList<DomElement>();
        if (list1 != null) {
            list.addAll(list1);
        }
        if (list2 != null) {
            for (DomElement elt : list2) {
                if (list.contains(elt)) continue;
                list.add(elt);
            }
        }
        return list;
    }

    void addMappedElement(DomElement element) {
        this.addMappedElement(element, false);
    }

    void addMappedElement(DomElement element, boolean recurse) {
        if (this.isDescendant(element)) {
            this.addElement(this.idMap_, element, "id", recurse);
            this.addElement(this.nameMap_, element, "name", recurse);
        }
    }

    private void addElement(Map<String, List<DomElement>> map, DomElement element, String attribute, boolean recurse) {
        String value = element.getAttribute(attribute);
        if (DomElement.ATTRIBUTE_NOT_DEFINED != value) {
            List<DomElement> elements = map.get(value);
            if (elements == null) {
                elements = new ArrayList<DomElement>();
                elements.add(element);
                map.put(value, elements);
            } else if (!elements.contains(element)) {
                elements.add(element);
            }
        }
        if (recurse) {
            for (DomElement child : element.getChildElements()) {
                this.addElement(map, child, attribute, true);
            }
        }
    }

    void removeMappedElement(HtmlElement element) {
        this.removeMappedElement(element, false, false);
    }

    void removeMappedElement(DomElement element, boolean recurse, boolean descendant) {
        if (descendant || this.isDescendant(element)) {
            this.removeElement(this.idMap_, element, "id", recurse);
            this.removeElement(this.nameMap_, element, "name", recurse);
        }
    }

    private void removeElement(Map<String, List<DomElement>> map, DomElement element, String att, boolean recurse) {
        List<DomElement> elements;
        String value = element.getAttribute(att);
        if (!(StringUtils.isEmpty((CharSequence)value) || (elements = map.remove(value)) == null || elements.size() == 1 && elements.contains(element))) {
            elements.remove(element);
            map.put(value, elements);
        }
        if (recurse) {
            for (DomElement child : element.getChildElements()) {
                this.removeElement(map, child, att, true);
            }
        }
    }

    void notifyNodeAdded(DomNode node) {
        if (node instanceof DomElement) {
            this.addMappedElement((DomElement)node, true);
            if ("base".equals(node.getNodeName())) {
                this.calculateBase();
            }
        }
        node.onAddedToPage();
    }

    private void calculateBase() {
        List baseElements = this.getDocumentElement().getHtmlElementsByTagName("base");
        switch (baseElements.size()) {
            case 0: {
                this.base_ = null;
                break;
            }
            case 1: {
                this.base_ = (HtmlBase)baseElements.get(0);
                break;
            }
            default: {
                this.base_ = (HtmlBase)baseElements.get(0);
                this.notifyIncorrectness("Multiple 'base' detected, only the first is used.");
            }
        }
    }

    void notifyNodeRemoved(DomNode node) {
        if (node instanceof HtmlElement) {
            this.removeMappedElement((HtmlElement)node, true, true);
            if ("base".equals(node.getNodeName())) {
                this.calculateBase();
            }
        }
    }

    void loadFrames() throws FailingHttpStatusCodeException {
        for (FrameWindow w : this.getFrames()) {
            BaseFrameElement frame = w.getFrameElement();
            if (frame.getEnclosedWindow() == null || WebClient.URL_ABOUT_BLANK != frame.getEnclosedPage().getUrl() || frame.isContentLoaded()) continue;
            frame.loadInnerPage();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("HtmlPage(");
        buffer.append(this.getUrl());
        buffer.append(")@");
        buffer.append(this.hashCode());
        return buffer.toString();
    }

    public boolean setFocusedElement(HtmlElement newElement) {
        return this.setFocusedElement(newElement, false);
    }

    public boolean setFocusedElement(HtmlElement newElement, boolean windowActivated) {
        if (this.elementWithFocus_ == newElement && !windowActivated) {
            return true;
        }
        if (newElement != null && newElement.getPage() != this) {
            throw new IllegalArgumentException("Can't move focus to an element from a different page.");
        }
        HtmlElement oldFocusedElement = this.elementWithFocus_;
        this.elementWithFocus_ = null;
        if (!windowActivated) {
            if (oldFocusedElement != null) {
                oldFocusedElement.fireEvent("focusout");
            }
            if (newElement != null) {
                newElement.fireEvent("focusin");
            }
            if (oldFocusedElement != null) {
                if (this.hasFeature(BrowserVersionFeatures.BLUR_BEFORE_ONCHANGE)) {
                    oldFocusedElement.fireEvent("blur");
                    oldFocusedElement.removeFocus();
                } else {
                    oldFocusedElement.removeFocus();
                    oldFocusedElement.fireEvent("blur");
                }
            }
        }
        this.elementWithFocus_ = newElement;
        if (this.elementWithFocus_ instanceof SelectableTextInput && this.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.PAGE_SELECTION_RANGE_FROM_SELECTABLE_TEXT_INPUT)) {
            SelectableTextInput sti = (SelectableTextInput)((Object)this.elementWithFocus_);
            this.setSelectionRange(new SimpleRange(sti, sti.getSelectionStart(), sti, sti.getSelectionEnd()));
        }
        if (this.elementWithFocus_ != null) {
            this.elementWithFocus_.focus();
            this.elementWithFocus_.fireEvent("focus");
        }
        return this == this.getEnclosingWindow().getEnclosedPage();
    }

    public HtmlElement getFocusedElement() {
        return this.elementWithFocus_;
    }

    protected List<HtmlMeta> getMetaTags(String httpEquiv) {
        if (this.getDocumentElement() == null) {
            return Collections.emptyList();
        }
        String nameLC = httpEquiv.toLowerCase();
        List<HtmlMeta> tags = this.getDocumentElement().getHtmlElementsByTagName("meta");
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            HtmlMeta element = (HtmlMeta)iter.next();
            if (nameLC.equals(element.getHttpEquivAttribute().toLowerCase())) continue;
            iter.remove();
        }
        return tags;
    }

    void setCheckedRadioButton(HtmlRadioButtonInput radioButtonInput) {
        List<?> pageInputs = this.getByXPath("//input[lower-case(@type)='radio' and @name='" + radioButtonInput.getNameAttribute() + "']");
        List<?> formInputs = this.getByXPath("//form//input[lower-case(@type)='radio' and @name='" + radioButtonInput.getNameAttribute() + "']");
        pageInputs.removeAll(formInputs);
        boolean found = false;
        for (HtmlRadioButtonInput input : pageInputs) {
            if (input == radioButtonInput) {
                input.setAttribute("checked", "checked");
                found = true;
                continue;
            }
            input.removeAttribute("checked");
        }
        for (HtmlRadioButtonInput input : formInputs) {
            if (input != radioButtonInput) continue;
            found = true;
        }
        if (!found) {
            radioButtonInput.setAttribute("checked", "checked");
        }
    }

    @Override
    protected HtmlPage clone() {
        HtmlPage result = (HtmlPage)super.clone();
        result.elementWithFocus_ = null;
        result.idMap_ = new HashMap<String, List<DomElement>>();
        result.nameMap_ = new HashMap<String, List<DomElement>>();
        return result;
    }

    @Override
    public HtmlPage cloneNode(boolean deep) {
        HtmlPage result = (HtmlPage)super.cloneNode(deep);
        SimpleScriptable jsObjClone = ((SimpleScriptable)this.getScriptObject()).clone();
        jsObjClone.setDomNode(result);
        if (deep) {
            for (HtmlElement child : result.getHtmlElementDescendants()) {
                this.removeMappedElement(child);
                result.addMappedElement(child);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ == null) {
                this.attributeListeners_ = new ArrayList<HtmlAttributeChangeListener>();
            }
            if (!this.attributeListeners_.contains(listener)) {
                this.attributeListeners_.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ != null) {
                this.attributeListeners_.remove(listener);
            }
        }
    }

    void fireHtmlAttributeAdded(HtmlAttributeChangeEvent event) {
        List<HtmlAttributeChangeListener> listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            for (HtmlAttributeChangeListener listener : listeners) {
                listener.attributeAdded(event);
            }
        }
    }

    void fireHtmlAttributeReplaced(HtmlAttributeChangeEvent event) {
        List<HtmlAttributeChangeListener> listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            for (HtmlAttributeChangeListener listener : listeners) {
                listener.attributeReplaced(event);
            }
        }
    }

    void fireHtmlAttributeRemoved(HtmlAttributeChangeEvent event) {
        List<HtmlAttributeChangeListener> listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            for (HtmlAttributeChangeListener listener : listeners) {
                listener.attributeRemoved(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HtmlAttributeChangeListener> safeGetAttributeListeners() {
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ != null) {
                return new ArrayList<HtmlAttributeChangeListener>(this.attributeListeners_);
            }
            return null;
        }
    }

    @Override
    protected void checkChildHierarchy(org.w3c.dom.Node newChild) throws DOMException {
        if (newChild instanceof Element) {
            if (this.getDocumentElement() != null) {
                throw new DOMException(3, "The Document may only have a single child Element.");
            }
        } else if (newChild instanceof DocumentType) {
            if (this.getDoctype() != null) {
                throw new DOMException(3, "The Document may only have a single child DocumentType.");
            }
        } else if (!(newChild instanceof Comment) && !(newChild instanceof ProcessingInstruction)) {
            throw new DOMException(3, "The Document may not have a child of this type: " + newChild.getNodeType());
        }
        super.checkChildHierarchy(newChild);
    }

    public boolean isOnbeforeunloadAccepted() {
        return this.executeEventHandlersIfNeeded("beforeunload");
    }

    public boolean isBeingParsed() {
        return this.parserCount_ > 0;
    }

    void registerParsingStart() {
        ++this.parserCount_;
    }

    void registerParsingEnd() {
        --this.parserCount_;
    }

    boolean isParsingHtmlSnippet() {
        return this.snippetParserCount_ > 0;
    }

    void registerSnippetParsingStart() {
        ++this.snippetParserCount_;
    }

    void registerSnippetParsingEnd() {
        --this.snippetParserCount_;
        if (0 == this.snippetParserCount_) {
            this.loadFrames();
        }
    }

    boolean isParsingInlineHtmlSnippet() {
        return this.inlineSnippetParserCount_ > 0;
    }

    void registerInlineSnippetParsingStart() {
        ++this.inlineSnippetParserCount_;
    }

    void registerInlineSnippetParsingEnd() {
        --this.inlineSnippetParserCount_;
    }

    public Page refresh() throws IOException {
        return this.getWebClient().getPage(this.getWebResponse().getWebRequest());
    }

    public void writeInParsedStream(String string) {
        this.builder_.pushInputString(string);
    }

    void setBuilder(HTMLParser.HtmlUnitDOMBuilder htmlUnitDOMBuilder) {
        this.builder_ = htmlUnitDOMBuilder;
    }

    HTMLParser.HtmlUnitDOMBuilder getBuilder() {
        return this.builder_;
    }

    public List<Range> getSelectionRanges() {
        return this.selectionRanges_;
    }

    public void setSelectionRange(Range selectionRange) {
        this.selectionRanges_.clear();
        this.selectionRanges_.add(selectionRange);
    }

    public Map<String, String> getNamespaces() {
        NamedNodeMap attributes = this.getDocumentElement().getAttributes();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            if (!name.startsWith("xmlns")) continue;
            int startPos = 5;
            if (name.length() > 5 && name.charAt(5) == ':') {
                startPos = 6;
            }
            name = name.substring(startPos);
            namespaces.put(name, attr.getValue());
        }
        return namespaces;
    }

    @Override
    protected void setDocumentType(DomDocumentType type) {
        super.setDocumentType(type);
    }

    public void save(File file) throws IOException {
        new XmlSerializer().save(this, file);
    }

    static boolean isMappedElement(Document document, String attributeName) {
        return document instanceof HtmlPage && ("name".equals(attributeName) || "id".equals(attributeName));
    }

    public boolean isQuirksMode() {
        return ((HTMLDocument)this.getScriptObject()).getDocumentMode() == 5;
    }

    @Override
    protected boolean isDirectlyAttachedToPage() {
        return true;
    }

    static enum JavaScriptLoadResult {
        NOOP,
        SUCCESS,
        DOWNLOAD_ERROR,
        COMPILATION_ERROR;

    }
}

