/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.monitoring;

import com.google.common.base.Preconditions;
import java.net.BindException;
import java.net.URI;
import nl.surfnet.coin.monitoring.AbstractMonitor;
import nl.surfnet.coin.monitoring.MujinaServer;
import nl.surfnet.coin.monitoring.Tester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SAMLMonitor
extends AbstractMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLMonitor.class);
    private static MujinaServer mujinaServer;

    public static void main(String[] args) throws Exception {
        new SAMLMonitor().monitor();
    }

    public void monitor() throws Exception {
        try {
            String conextDomain = this.getProperty("conextDomain");
            String privateKeyPath = this.getProperty("mujinaPrivateKeyPath");
            String certPath = this.getProperty("mujinaCertPath");
            String sslPort = this.getProperty("mujinaSslPort");
            Preconditions.checkArgument((boolean)StringUtils.hasText((String)sslPort), (Object)"The sslPort property in monitor.properties is absent");
            LOG.info("Setting up Jetty servlet container and deploying Mujina IdP and SP");
            mujinaServer = new MujinaServer();
            URI mujinaBaseUri = mujinaServer.setupServer(conextDomain, privateKeyPath, certPath, Integer.valueOf(sslPort));
            LOG.info("Running tests");
            new Tester(mujinaBaseUri, "https://monitoring-idp", "/sp").runTests();
            LOG.info("All tests succeeded");
            mujinaServer.stop();
            System.exit(0);
        }
        catch (BindException e) {
            LOG.warn("Address in use. We terminate normally as this can happen because the previous test is still running");
            System.exit(0);
        }
        catch (Throwable t) {
            LOG.error("Exiting because of exception", t);
            mujinaServer.stop();
            System.exit(2);
        }
    }
}

