/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.PluginConfiguration;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserFeature;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BrowserVersion
implements Serializable,
Cloneable {
    private String applicationCodeName_ = "Mozilla";
    private String applicationMinorVersion_ = "0";
    private String applicationName_;
    private String applicationVersion_;
    private String browserLanguage_ = "en-us";
    private String cpuClass_ = "x86";
    private boolean onLine_ = true;
    private String platform_ = "Win32";
    private String systemLanguage_ = "en-us";
    private String userAgent_;
    private String userLanguage_ = "en-us";
    private float browserVersionNumeric_;
    private final Set<PluginConfiguration> plugins_ = new HashSet<PluginConfiguration>();
    private final Set<BrowserVersionFeatures> features_ = EnumSet.noneOf(BrowserVersionFeatures.class);
    private final String nickname_;
    private static final String INTERNET_EXPLORER = "Microsoft Internet Explorer";
    private static final String NETSCAPE = "Netscape";
    private static final String LANGUAGE_ENGLISH_US = "en-us";
    private static final String CPU_CLASS_X86 = "x86";
    private static final String PLATFORM_WIN32 = "Win32";
    @Deprecated
    public static final BrowserVersion FIREFOX_3_6 = new BrowserVersion("Netscape", "5.0 (Windows; en-US)", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.28) Gecko/20120306 Firefox/3.6.28", 3.6f, "FF3.6", null);
    @Deprecated
    public static final BrowserVersion FIREFOX_10 = new BrowserVersion("Netscape", "5.0 (Windows)", "Mozilla/5.0 (Windows NT 6.1; rv:10.0.11) Gecko/20100101 Firefox/10.0.11", 10.0f, "FF10", null);
    public static final BrowserVersion FIREFOX_17 = new BrowserVersion("Netscape", "5.0 (Windows)", "Mozilla/5.0 (Windows NT 6.1; rv:17.0) Gecko/20100101 Firefox/17.0", 17.0f, "FF17", null);
    @Deprecated
    public static final BrowserVersion INTERNET_EXPLORER_6 = new BrowserVersion("Microsoft Internet Explorer", "4.0 (compatible; MSIE 6.0b; Windows 98)", "Mozilla/4.0 (compatible; MSIE 6.0; Windows 98)", 6.0f, "IE6", null);
    @Deprecated
    public static final BrowserVersion INTERNET_EXPLORER_7 = new BrowserVersion("Microsoft Internet Explorer", "4.0 (compatible; MSIE 7.0; Windows NT 5.1)", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)", 7.0f, "IE7", null);
    public static final BrowserVersion INTERNET_EXPLORER_8 = new BrowserVersion("Microsoft Internet Explorer", "4.0 (compatible; MSIE 8.0; Windows NT 6.0)", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0)", 8.0f, "IE8", null);
    public static final BrowserVersion INTERNET_EXPLORER_9 = new BrowserVersion("Microsoft Internet Explorer", "5.0 (compatible; MSIE 9.0; Windows NT 6.1)", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1)", 9.0f, "IE9", null);
    @Deprecated
    public static final BrowserVersion CHROME_16 = new BrowserVersion("Netscape", "5.0 (Macintosh; Intel Mac OS X 10_7_2) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_2) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.63 Safari/535.7", 16.0f, "Chrome16", null);
    public static final BrowserVersion CHROME = new BrowserVersion("Netscape", "5.0 (Windows NT 6.1) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11", 23.0f, "Chrome", null);
    private static BrowserVersion DefaultBrowserVersion_ = INTERNET_EXPLORER_8;

    public BrowserVersion(String applicationName, String applicationVersion, String userAgent, float browserVersionNumeric) {
        this(applicationName, applicationVersion, userAgent, browserVersionNumeric, applicationName + browserVersionNumeric, null);
    }

    public BrowserVersion(String applicationName, String applicationVersion, String userAgent, float browserVersionNumeric, BrowserVersionFeatures[] features) {
        this(applicationName, applicationVersion, userAgent, browserVersionNumeric, applicationName + browserVersionNumeric, features);
    }

    private BrowserVersion(String applicationName, String applicationVersion, String userAgent, float browserVersionNumeric, String nickname, BrowserVersionFeatures[] features) {
        this.applicationName_ = applicationName;
        this.setApplicationVersion(applicationVersion);
        this.userAgent_ = userAgent;
        this.browserVersionNumeric_ = browserVersionNumeric;
        this.nickname_ = nickname;
        if (features != null) {
            this.features_.addAll(Arrays.asList(features));
        }
    }

    private void initDefaultFeatures() {
        String expectedBrowserName = this.isIE() ? "IE" : (this.isFirefox() ? "FF" : "CHROME");
        for (BrowserVersionFeatures features : BrowserVersionFeatures.values()) {
            try {
                Field field = BrowserVersionFeatures.class.getField(features.name());
                BrowserFeature browserFeature = field.getAnnotation(BrowserFeature.class);
                if (browserFeature == null) continue;
                for (WebBrowser browser : browserFeature.value()) {
                    if (!expectedBrowserName.equals(browser.value().name()) || !(browser.minVersion() <= this.getBrowserVersionNumeric()) || !(browser.maxVersion() >= this.getBrowserVersionNumeric())) continue;
                    this.features_.add(features);
                }
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException();
            }
        }
    }

    public static BrowserVersion getDefault() {
        return DefaultBrowserVersion_;
    }

    public static void setDefault(BrowserVersion newBrowserVersion) {
        WebAssert.notNull("newBrowserVersion", newBrowserVersion);
        DefaultBrowserVersion_ = newBrowserVersion;
    }

    public final boolean isIE() {
        return INTERNET_EXPLORER.equals(this.getApplicationName());
    }

    public final boolean isChrome() {
        return this.getNickname().startsWith("Chrome");
    }

    public final boolean isFirefox() {
        return !this.isChrome() && NETSCAPE.equals(this.getApplicationName());
    }

    public String getApplicationCodeName() {
        return this.applicationCodeName_;
    }

    public String getApplicationMinorVersion() {
        return this.applicationMinorVersion_;
    }

    public String getApplicationName() {
        return this.applicationName_;
    }

    public String getApplicationVersion() {
        return this.applicationVersion_;
    }

    public String getBrowserLanguage() {
        return this.browserLanguage_;
    }

    public String getCpuClass() {
        return this.cpuClass_;
    }

    public boolean isOnLine() {
        return this.onLine_;
    }

    public String getPlatform() {
        return this.platform_;
    }

    public String getSystemLanguage() {
        return this.systemLanguage_;
    }

    public String getUserAgent() {
        return this.userAgent_;
    }

    public String getUserLanguage() {
        return this.userLanguage_;
    }

    public void setApplicationCodeName(String applicationCodeName) {
        this.applicationCodeName_ = applicationCodeName;
    }

    public void setApplicationMinorVersion(String applicationMinorVersion) {
        this.applicationMinorVersion_ = applicationMinorVersion;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName_ = applicationName;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion_ = applicationVersion;
    }

    public void setBrowserLanguage(String browserLanguage) {
        this.browserLanguage_ = browserLanguage;
    }

    public void setCpuClass(String cpuClass) {
        this.cpuClass_ = cpuClass;
    }

    public void setOnLine(boolean onLine) {
        this.onLine_ = onLine;
    }

    public void setPlatform(String platform) {
        this.platform_ = platform;
    }

    public void setSystemLanguage(String systemLanguage) {
        this.systemLanguage_ = systemLanguage;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent_ = userAgent;
    }

    public void setUserLanguage(String userLanguage) {
        this.userLanguage_ = userLanguage;
    }

    public void setBrowserVersion(float browserVersion) {
        this.browserVersionNumeric_ = browserVersion;
    }

    public float getBrowserVersionNumeric() {
        return this.browserVersionNumeric_;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public Set<PluginConfiguration> getPlugins() {
        return this.plugins_;
    }

    public boolean hasFeature(BrowserVersionFeatures property) {
        return this.features_.contains((Object)property);
    }

    public String getNickname() {
        return this.nickname_;
    }

    public BrowserVersion clone() {
        BrowserVersion clone = new BrowserVersion(this.getApplicationName(), this.getApplicationVersion(), this.getUserAgent(), this.getBrowserVersionNumeric(), this.getNickname(), null);
        clone.setApplicationCodeName(this.getApplicationCodeName());
        clone.setApplicationMinorVersion(this.getApplicationMinorVersion());
        clone.setBrowserLanguage(this.getBrowserLanguage());
        clone.setCpuClass(this.getCpuClass());
        clone.setOnLine(this.isOnLine());
        clone.setPlatform(this.getPlatform());
        clone.setSystemLanguage(this.getSystemLanguage());
        clone.setUserLanguage(this.getUserLanguage());
        for (PluginConfiguration pluginConf : this.getPlugins()) {
            clone.getPlugins().add(pluginConf.clone());
        }
        clone.features_.addAll(this.features_);
        return clone;
    }

    static {
        INTERNET_EXPLORER_6.initDefaultFeatures();
        INTERNET_EXPLORER_7.initDefaultFeatures();
        INTERNET_EXPLORER_8.initDefaultFeatures();
        INTERNET_EXPLORER_9.initDefaultFeatures();
        FIREFOX_3_6.initDefaultFeatures();
        FIREFOX_10.initDefaultFeatures();
        FIREFOX_17.initDefaultFeatures();
        PluginConfiguration flash = new PluginConfiguration("Shockwave Flash", "Shockwave Flash 9.0 r31", "libflashplayer.so");
        flash.getMimeTypes().add(new PluginConfiguration.MimeType("application/x-shockwave-flash", "Shockwave Flash", "swf"));
        FIREFOX_3_6.getPlugins().add(flash);
        FIREFOX_10.getPlugins().add(flash);
        FIREFOX_17.getPlugins().add(flash);
        CHROME_16.initDefaultFeatures();
        CHROME_16.setApplicationCodeName("Mozilla");
        CHROME_16.setPlatform("MacIntel");
        CHROME_16.setCpuClass(null);
        CHROME_16.setBrowserLanguage("undefined");
        CHROME.initDefaultFeatures();
        CHROME.setApplicationCodeName("Mozilla");
        CHROME.setPlatform("MacIntel");
        CHROME.setCpuClass(null);
        CHROME.setBrowserLanguage("undefined");
    }
}

