/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.GenericApplicationListenerAdapter;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.context.DelegatingApplicationListener;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.ChangeSessionIdAuthenticationStrategy;
import org.springframework.security.web.authentication.session.CompositeSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlAuthenticationStrategy;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.NullSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.savedrequest.NullRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.security.web.session.SimpleRedirectInvalidSessionStrategy;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionManagementConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<SessionManagementConfigurer<H>, H> {
    private final SessionAuthenticationStrategy DEFAULT_SESSION_FIXATION_STRATEGY;
    private SessionAuthenticationStrategy sessionFixationAuthenticationStrategy;
    private SessionAuthenticationStrategy sessionAuthenticationStrategy;
    private InvalidSessionStrategy invalidSessionStrategy;
    private List<SessionAuthenticationStrategy> sessionAuthenticationStrategies;
    private SessionRegistry sessionRegistry;
    private Integer maximumSessions;
    private String expiredUrl;
    private boolean maxSessionsPreventsLogin;
    private SessionCreationPolicy sessionPolicy;
    private boolean enableSessionUrlRewriting;
    private String invalidSessionUrl;
    private String sessionAuthenticationErrorUrl;

    public SessionManagementConfigurer() {
        this.sessionFixationAuthenticationStrategy = this.DEFAULT_SESSION_FIXATION_STRATEGY = SessionManagementConfigurer.createDefaultSessionFixationProtectionStrategy();
        this.sessionAuthenticationStrategies = new ArrayList<SessionAuthenticationStrategy>();
        this.sessionPolicy = SessionCreationPolicy.IF_REQUIRED;
    }

    public SessionManagementConfigurer<H> invalidSessionUrl(String invalidSessionUrl) {
        this.invalidSessionUrl = invalidSessionUrl;
        return this;
    }

    public SessionManagementConfigurer<H> sessionAuthenticationErrorUrl(String sessionAuthenticationErrorUrl) {
        this.sessionAuthenticationErrorUrl = sessionAuthenticationErrorUrl;
        return this;
    }

    public SessionManagementConfigurer<H> enableSessionUrlRewriting(boolean enableSessionUrlRewriting) {
        this.enableSessionUrlRewriting = enableSessionUrlRewriting;
        return this;
    }

    public SessionManagementConfigurer<H> sessionCreationPolicy(SessionCreationPolicy sessionCreationPolicy) {
        Assert.notNull((Object)((Object)sessionCreationPolicy), (String)"sessionCreationPolicy cannot be null");
        this.sessionPolicy = sessionCreationPolicy;
        return this;
    }

    public SessionManagementConfigurer<H> sessionAuthenticationStrategy(SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        this.sessionFixationAuthenticationStrategy = sessionAuthenticationStrategy;
        return this;
    }

    SessionManagementConfigurer<H> addSessionAuthenticationStrategy(SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        this.sessionAuthenticationStrategies.add(sessionAuthenticationStrategy);
        return this;
    }

    public SessionFixationConfigurer sessionFixation() {
        return new SessionFixationConfigurer();
    }

    public ConcurrencyControlConfigurer maximumSessions(int maximumSessions) {
        this.maximumSessions = maximumSessions;
        return new ConcurrencyControlConfigurer();
    }

    private void setSessionFixationAuthenticationStrategy(SessionAuthenticationStrategy sessionFixationAuthenticationStrategy) {
        this.sessionFixationAuthenticationStrategy = this.postProcess(sessionFixationAuthenticationStrategy);
    }

    @Override
    public void init(H http) throws Exception {
        RequestCache requestCache;
        SecurityContextRepository securityContextRepository = http.getSharedObject(SecurityContextRepository.class);
        boolean stateless = this.isStateless();
        if (securityContextRepository == null) {
            if (stateless) {
                http.setSharedObject(SecurityContextRepository.class, (NullSecurityContextRepository)new NullSecurityContextRepository());
            } else {
                HttpSessionSecurityContextRepository httpSecurityRepository = new HttpSessionSecurityContextRepository();
                httpSecurityRepository.setDisableUrlRewriting(!this.enableSessionUrlRewriting);
                httpSecurityRepository.setAllowSessionCreation(this.isAllowSessionCreation());
                AuthenticationTrustResolver trustResolver = http.getSharedObject(AuthenticationTrustResolver.class);
                if (trustResolver != null) {
                    httpSecurityRepository.setTrustResolver(trustResolver);
                }
                http.setSharedObject(SecurityContextRepository.class, (HttpSessionSecurityContextRepository)httpSecurityRepository);
            }
        }
        if ((requestCache = http.getSharedObject(RequestCache.class)) == null && stateless) {
            http.setSharedObject(RequestCache.class, (NullRequestCache)new NullRequestCache());
        }
        http.setSharedObject(SessionAuthenticationStrategy.class, (SessionAuthenticationStrategy)this.getSessionAuthenticationStrategy(http));
        http.setSharedObject(InvalidSessionStrategy.class, (InvalidSessionStrategy)this.getInvalidSessionStrategy());
    }

    @Override
    public void configure(H http) throws Exception {
        AuthenticationTrustResolver trustResolver;
        SecurityContextRepository securityContextRepository = http.getSharedObject(SecurityContextRepository.class);
        SessionManagementFilter sessionManagementFilter = new SessionManagementFilter(securityContextRepository, this.getSessionAuthenticationStrategy(http));
        if (this.sessionAuthenticationErrorUrl != null) {
            sessionManagementFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)new SimpleUrlAuthenticationFailureHandler(this.sessionAuthenticationErrorUrl));
        }
        if (this.invalidSessionUrl != null) {
            sessionManagementFilter.setInvalidSessionStrategy(this.getInvalidSessionStrategy());
        }
        if ((trustResolver = http.getSharedObject(AuthenticationTrustResolver.class)) != null) {
            sessionManagementFilter.setTrustResolver(trustResolver);
        }
        sessionManagementFilter = this.postProcess(sessionManagementFilter);
        http.addFilter((Filter)sessionManagementFilter);
        if (this.isConcurrentSessionControlEnabled()) {
            ConcurrentSessionFilter concurrentSessionFilter = new ConcurrentSessionFilter(this.getSessionRegistry(http), this.expiredUrl);
            concurrentSessionFilter = this.postProcess(concurrentSessionFilter);
            http.addFilter((Filter)concurrentSessionFilter);
        }
    }

    InvalidSessionStrategy getInvalidSessionStrategy() {
        if (this.invalidSessionUrl == null) {
            return null;
        }
        if (this.invalidSessionStrategy == null) {
            this.invalidSessionStrategy = new SimpleRedirectInvalidSessionStrategy(this.invalidSessionUrl);
        }
        return this.invalidSessionStrategy;
    }

    SessionCreationPolicy getSessionCreationPolicy() {
        return this.sessionPolicy;
    }

    private boolean isAllowSessionCreation() {
        return SessionCreationPolicy.ALWAYS == this.sessionPolicy || SessionCreationPolicy.IF_REQUIRED == this.sessionPolicy;
    }

    private boolean isStateless() {
        return SessionCreationPolicy.STATELESS == this.sessionPolicy;
    }

    private SessionAuthenticationStrategy getSessionAuthenticationStrategy(H http) {
        if (this.sessionAuthenticationStrategy != null) {
            return this.sessionAuthenticationStrategy;
        }
        List<SessionAuthenticationStrategy> delegateStrategies = this.sessionAuthenticationStrategies;
        if (this.DEFAULT_SESSION_FIXATION_STRATEGY == this.sessionFixationAuthenticationStrategy) {
            this.sessionFixationAuthenticationStrategy = this.postProcess(this.sessionFixationAuthenticationStrategy);
        }
        if (this.isConcurrentSessionControlEnabled()) {
            SessionRegistry sessionRegistry = this.getSessionRegistry(http);
            ConcurrentSessionControlAuthenticationStrategy concurrentSessionControlStrategy = new ConcurrentSessionControlAuthenticationStrategy(sessionRegistry);
            concurrentSessionControlStrategy.setMaximumSessions(this.maximumSessions.intValue());
            concurrentSessionControlStrategy.setExceptionIfMaximumExceeded(this.maxSessionsPreventsLogin);
            concurrentSessionControlStrategy = this.postProcess(concurrentSessionControlStrategy);
            RegisterSessionAuthenticationStrategy registerSessionStrategy = new RegisterSessionAuthenticationStrategy(sessionRegistry);
            registerSessionStrategy = this.postProcess(registerSessionStrategy);
            delegateStrategies.addAll(Arrays.asList(concurrentSessionControlStrategy, this.sessionFixationAuthenticationStrategy, registerSessionStrategy));
        } else {
            delegateStrategies.add(this.sessionFixationAuthenticationStrategy);
        }
        this.sessionAuthenticationStrategy = (SessionAuthenticationStrategy)this.postProcess(new CompositeSessionAuthenticationStrategy(delegateStrategies));
        return this.sessionAuthenticationStrategy;
    }

    private SessionRegistry getSessionRegistry(H http) {
        if (this.sessionRegistry == null) {
            SessionRegistryImpl sessionRegistry = new SessionRegistryImpl();
            this.registerDelegateApplicationListener(http, (ApplicationListener<?>)sessionRegistry);
            this.sessionRegistry = sessionRegistry;
        }
        return this.sessionRegistry;
    }

    private void registerDelegateApplicationListener(H http, ApplicationListener<?> delegate) {
        ApplicationContext context = http.getSharedObject(ApplicationContext.class);
        if (context == null) {
            return;
        }
        if (context.getBeansOfType(DelegatingApplicationListener.class).isEmpty()) {
            return;
        }
        DelegatingApplicationListener delegating = (DelegatingApplicationListener)context.getBean(DelegatingApplicationListener.class);
        GenericApplicationListenerAdapter smartListener = new GenericApplicationListenerAdapter(delegate);
        delegating.addListener((SmartApplicationListener)smartListener);
    }

    private boolean isConcurrentSessionControlEnabled() {
        return this.maximumSessions != null;
    }

    private static SessionAuthenticationStrategy createDefaultSessionFixationProtectionStrategy() {
        try {
            return new ChangeSessionIdAuthenticationStrategy();
        }
        catch (IllegalStateException e) {
            return new SessionFixationProtectionStrategy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ConcurrencyControlConfigurer {
        public ConcurrencyControlConfigurer expiredUrl(String expiredUrl) {
            SessionManagementConfigurer.this.expiredUrl = expiredUrl;
            return this;
        }

        public ConcurrencyControlConfigurer maxSessionsPreventsLogin(boolean maxSessionsPreventsLogin) {
            SessionManagementConfigurer.this.maxSessionsPreventsLogin = maxSessionsPreventsLogin;
            return this;
        }

        public ConcurrencyControlConfigurer sessionRegistry(SessionRegistry sessionRegistry) {
            SessionManagementConfigurer.this.sessionRegistry = sessionRegistry;
            return this;
        }

        public SessionManagementConfigurer<H> and() {
            return SessionManagementConfigurer.this;
        }

        private ConcurrencyControlConfigurer() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class SessionFixationConfigurer {
        public SessionManagementConfigurer<H> newSession() {
            SessionFixationProtectionStrategy sessionFixationProtectionStrategy = new SessionFixationProtectionStrategy();
            sessionFixationProtectionStrategy.setMigrateSessionAttributes(false);
            SessionManagementConfigurer.this.setSessionFixationAuthenticationStrategy((SessionAuthenticationStrategy)sessionFixationProtectionStrategy);
            return SessionManagementConfigurer.this;
        }

        public SessionManagementConfigurer<H> migrateSession() {
            SessionManagementConfigurer.this.setSessionFixationAuthenticationStrategy((SessionAuthenticationStrategy)new SessionFixationProtectionStrategy());
            return SessionManagementConfigurer.this;
        }

        public SessionManagementConfigurer<H> changeSessionId() {
            SessionManagementConfigurer.this.setSessionFixationAuthenticationStrategy((SessionAuthenticationStrategy)new ChangeSessionIdAuthenticationStrategy());
            return SessionManagementConfigurer.this;
        }

        public SessionManagementConfigurer<H> none() {
            SessionManagementConfigurer.this.setSessionFixationAuthenticationStrategy((SessionAuthenticationStrategy)new NullAuthenticatedSessionStrategy());
            return SessionManagementConfigurer.this;
        }
    }
}

