/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.api.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.surfnet.coin.api.client.OAuthRepository;

public class InMemoryOAuthRepositoryImpl
implements OAuthRepository {
    private Map<String, String> userSpecificTokens = new ConcurrentHashMap<String, String>();
    private String nonUserSpecificToken = null;

    @Override
    public String getToken(String userId) {
        return userId == null ? this.nonUserSpecificToken : this.userSpecificTokens.get(userId);
    }

    @Override
    public void storeToken(String accessToken, String userId) {
        if (userId == null) {
            this.nonUserSpecificToken = accessToken;
        } else {
            this.userSpecificTokens.put(userId, accessToken);
        }
    }

    @Override
    public void removeToken(String onBehalfOf) {
        if (onBehalfOf == null) {
            this.nonUserSpecificToken = null;
        } else {
            this.userSpecificTokens.remove(onBehalfOf);
        }
    }
}

