/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.api.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.surfnet.coin.api.client.InMemoryOAuthRepositoryImpl;
import nl.surfnet.coin.api.client.InvalidTokenException;
import nl.surfnet.coin.api.client.OAuthEnvironment;
import nl.surfnet.coin.api.client.OAuthRepository;
import nl.surfnet.coin.api.client.OAuthVersion;
import nl.surfnet.coin.api.client.OpenConextJsonParser;
import nl.surfnet.coin.api.client.OpenConextOAuthClient;
import nl.surfnet.coin.api.client.domain.Group;
import nl.surfnet.coin.api.client.domain.Group20;
import nl.surfnet.coin.api.client.domain.Person;
import nl.surfnet.coin.api.client.internal.OAuth2Grant;
import nl.surfnet.coin.api.client.internal.OpenConextApi20AuthorizationCode;
import nl.surfnet.coin.api.client.internal.OpenConextApi20ClientCredentials;
import org.apache.commons.io.IOUtils;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.builder.api.DefaultApi20;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OpenConextOAuthClientImpl
implements OpenConextOAuthClient,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(OpenConextOAuthClientImpl.class);
    private static final int MAX_ACCESS_TOKEN_REQUESTS = 3;
    private OAuthEnvironment environment;
    private OAuthRepository repository;
    private OpenConextJsonParser parser = new OpenConextJsonParser();

    public OpenConextOAuthClientImpl() {
        this.environment = new OAuthEnvironment();
        this.repository = new InMemoryOAuthRepositoryImpl();
    }

    @Override
    public boolean isAccessTokenGranted(String userId) {
        return this.repository.getToken(userId) != null;
    }

    private String doGetAuthorizationUrl(HttpServletRequest request) {
        OAuthService service = this.getService(OAuth2Grant.authorizationCode);
        return service.getAuthorizationUrl(null);
    }

    @Override
    public String getAuthorizationUrl() {
        return this.doGetAuthorizationUrl(null);
    }

    @Override
    public void oauthCallback(HttpServletRequest request, String onBehalfOf) {
        Token requestToken = null;
        String oAuthVerifier = request.getParameter("code");
        Verifier verifier = new Verifier(oAuthVerifier);
        OAuthService service = this.getService(OAuth2Grant.authorizationCode);
        String accessToken = service.getAccessToken(requestToken, verifier).getToken();
        this.repository.storeToken(accessToken, onBehalfOf);
    }

    @Override
    public Person getPerson(String userId, String onBehalfOf) {
        OAuthRequest request = new OAuthRequest(Verb.GET, this.environment.getEndpointBaseUrl() + "social/rest/people/" + userId);
        InputStream in = this.execute(onBehalfOf, request);
        return this.parser.parsePerson(in).getEntry();
    }

    @Override
    public List<Person> getGroupMembers(String groupId, String onBehalfOf) {
        if (!StringUtils.hasText((String)onBehalfOf)) {
            throw new IllegalArgumentException("For retrieving group members the onBehalfOf may not be empty");
        }
        OAuthRequest request = new OAuthRequest(Verb.GET, this.environment.getEndpointBaseUrl() + "social/rest/people/" + onBehalfOf + "/" + groupId);
        InputStream in = this.execute(onBehalfOf, request);
        return this.parser.parseTeamMembers(in).getEntry();
    }

    @Override
    public List<Group> getGroups(String userId, String onBehalfOf) {
        OAuthRequest request = new OAuthRequest(Verb.GET, this.environment.getEndpointBaseUrl() + "social/rest/groups/" + userId);
        InputStream in = this.execute(onBehalfOf, request);
        return this.parser.parseGroups(in).getEntry();
    }

    @Override
    public List<Group20> getGroups20(String userId, String onBehalfOf) {
        OAuthRequest request = new OAuthRequest(Verb.GET, this.environment.getEndpointBaseUrl() + "social/rest/groups/" + userId);
        InputStream in = this.execute(onBehalfOf, request);
        return this.parser.parseGroups20(in).getEntry();
    }

    @Override
    public Group20 getGroup20(String userId, String groupId, String onBehalfOf) {
        String url = String.format("%ssocial/rest/groups/%s/%s", this.environment.getEndpointBaseUrl(), userId, groupId);
        OAuthRequest request = new OAuthRequest(Verb.GET, url);
        InputStream in = this.execute(onBehalfOf, request);
        List<Group20> entry = this.parser.parseGroups20(in).getEntry();
        if (entry != null && entry.size() > 0) {
            return entry.get(0);
        }
        return null;
    }

    private InputStream execute(String onBehalfOf, OAuthRequest request) {
        Response oAuthResponse;
        OAuthService service;
        String token = this.repository.getToken(onBehalfOf);
        if (onBehalfOf == null) {
            int retries = 0;
            while (token == null && retries < 3) {
                this.getClientAccessToken();
                token = this.repository.getToken(onBehalfOf);
            }
            service = this.getService(OAuth2Grant.clientCredentials);
        } else {
            if (token == null) {
                throw new RuntimeException("No access token present for user('" + onBehalfOf + "'). First obtain an accesstoken.");
            }
            service = this.getService(OAuth2Grant.authorizationCode);
        }
        service.signRequest(new Token(token, ""), request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Will send request '{}'", (Object)request.toString());
        }
        if ((oAuthResponse = request.send()).getCode() >= 400) {
            if (oAuthResponse.getCode() == 401 && oAuthResponse.getStream() != null && oAuthResponse.getBody().contains("invalid_token")) {
                this.repository.removeToken(onBehalfOf);
                throw new InvalidTokenException(oAuthResponse.getBody());
            }
            throw new RuntimeException(String.format("Error response: %d, body: %s", oAuthResponse.getCode(), oAuthResponse.getStream() == null ? null : oAuthResponse.getBody()));
        }
        InputStream stream = oAuthResponse.getStream();
        if (LOG.isDebugEnabled()) {
            stream = this.logInputStream(stream);
        }
        return stream;
    }

    private InputStream logInputStream(InputStream stream) {
        String json;
        try {
            json = IOUtils.toString((InputStream)stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.debug(json);
        stream = IOUtils.toInputStream((String)json);
        return stream;
    }

    private OAuthService getService(OAuth2Grant grantType) {
        String baseUrl = this.environment.getEndpointBaseUrl();
        DefaultApi20 api = grantType.equals((Object)OAuth2Grant.clientCredentials) ? new OpenConextApi20ClientCredentials(baseUrl) : new OpenConextApi20AuthorizationCode(baseUrl);
        return new ServiceBuilder().provider((Api)api).apiKey(this.environment.getOauthKey()).scope("read").apiSecret(this.environment.getOauthSecret()).callback(this.environment.getCallbackUrl()).build();
    }

    public void setCallbackUrl(String url) {
        this.environment.setCallbackUrl(url);
    }

    public void setConsumerSecret(String secret) {
        this.environment.setOauthSecret(secret);
    }

    public void setConsumerKey(String key) {
        this.environment.setOauthKey(key);
    }

    public void setEndpointBaseUrl(String url) {
        this.environment.setEndpointBaseUrl(url);
    }

    public void setVersion(OAuthVersion v) {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.environment);
        Assert.notNull((Object)this.environment.getEndpointBaseUrl(), (String)"endpoint base url cannot be null");
        Assert.notNull((Object)this.repository);
    }

    public void setRepository(OAuthRepository repository) {
        this.repository = repository;
    }

    public void getClientAccessToken() {
        Token accessToken = this.getService(OAuth2Grant.clientCredentials).getAccessToken(new Token("", ""), new Verifier(""));
        LOG.debug("Received access token from OAuth 2 server: " + accessToken);
        this.repository.storeToken(accessToken.getToken(), null);
    }
}

