/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Set;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.DefaultOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.util.OAuth2Utils;

public final class OAuth2AccessTokenJackson2Deserializer
extends StdDeserializer<OAuth2AccessToken> {
    public OAuth2AccessTokenJackson2Deserializer() {
        super(OAuth2AccessToken.class);
    }

    public OAuth2AccessToken deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String tokenValue = null;
        String tokenType = null;
        String refreshToken = null;
        Long expiresIn = null;
        Set<String> scope = null;
        LinkedHashMap<String, Object> additionalInformation = new LinkedHashMap<String, Object>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            jp.nextToken();
            if ("access_token".equals(name)) {
                tokenValue = jp.getText();
                continue;
            }
            if ("token_type".equals(name)) {
                tokenType = jp.getText();
                continue;
            }
            if ("refresh_token".equals(name)) {
                refreshToken = jp.getText();
                continue;
            }
            if ("expires_in".equals(name)) {
                try {
                    expiresIn = jp.getLongValue();
                }
                catch (JsonParseException e) {
                    expiresIn = Long.valueOf(jp.getText());
                }
                continue;
            }
            if ("scope".equals(name)) {
                String text = jp.getText();
                scope = OAuth2Utils.parseParameterList(text);
                continue;
            }
            additionalInformation.put(name, jp.readValueAs(Object.class));
        }
        DefaultOAuth2AccessToken accessToken = new DefaultOAuth2AccessToken(tokenValue);
        accessToken.setTokenType(tokenType);
        if (expiresIn != null) {
            accessToken.setExpiration(new Date(System.currentTimeMillis() + expiresIn * 1000L));
        }
        if (refreshToken != null) {
            accessToken.setRefreshToken(new DefaultOAuth2RefreshToken(refreshToken));
        }
        accessToken.setScope(scope);
        accessToken.setAdditionalInformation(additionalInformation);
        return accessToken;
    }
}

