/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.monitoring;

import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMonitor.class);
    private Properties properties;

    public AbstractMonitor() {
        String propertiesFileName = System.getProperty("monitor.propertiesFile", "monitor.properties");
        this.loadProperties(propertiesFileName);
    }

    public void loadProperties(String propertiesFileName) {
        try {
            this.properties = new Properties();
            this.properties.load(new FileReader(propertiesFileName));
        }
        catch (IOException e) {
            LOG.error("while reading properties from monitor.properties", (Throwable)e);
        }
        LOG.debug("Loaded properties from {}", (Object)propertiesFileName);
        LOG.trace("Properties that were loaded: ", this.properties.propertyNames());
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }
}

