/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.net.http.SslError;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import java.util.logging.Level;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.android.library.Logger;

public class WebDriverViewClient {
    private final AndroidWebDriver driver;
    private final String LOG_TAG = WebDriverViewClient.class.getName();
    private String tmpUrl;

    public WebDriverViewClient(AndroidWebDriver driver) {
        this.driver = driver;
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        Logger.log(Level.WARNING, this.LOG_TAG, "onReceiveError", description + ", error code: " + errorCode);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        boolean shouldAcceptSslCerts = this.driver.getAcceptSslCerts();
        Logger.log(Level.WARNING, this.LOG_TAG, "onReceivedSslError", error.toString() + ", shouldAcceptSslCerts: " + shouldAcceptSslCerts);
        if (shouldAcceptSslCerts) {
            handler.proceed();
        }
    }

    public void onPageStarted(WebView view, String url) {
        if (this.driver.getWebView().equals(view)) {
            this.driver.setLastUrlLoaded(url);
            this.tmpUrl = url;
            this.driver.notifyPageStartedLoading();
        }
    }

    public void onPageFinished(WebView view, String url) {
        if (this.driver.getWebView().equals(view)) {
            this.driver.setLastUrlLoaded(url);
            if (url != null && this.tmpUrl != null && url.contains("#") && this.tmpUrl.equals(url.split("#")[0])) {
                this.driver.notifyPageDoneLoading();
            }
        }
    }
}

