/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.monitoring;

import java.net.URL;
import nl.surfnet.coin.monitoring.AbstractMonitor;
import nl.surfnet.coin.monitoring.Engineblock;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class MetadataMonitor
extends AbstractMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataMonitor.class);
    private Engineblock engineblock;

    public static void main(String[] args) throws Exception {
        new MetadataMonitor().monitor();
    }

    public void monitor() {
        try {
            String conextDomain = this.getProperty("conextDomain");
            String certificateFile = this.getProperty("engineBlockCertFile");
            String trustChainFile = this.getProperty("engineBlockTrustChainFile");
            String engineblockCertAsString = IOUtils.toString((URL)new ClassPathResource(certificateFile).getURL());
            String trustChainAsString = null;
            if (!trustChainFile.isEmpty()) {
                trustChainAsString = IOUtils.toString((URL)new ClassPathResource(trustChainFile).getURL());
            }
            this.engineblock = new Engineblock("https://engine." + conextDomain, engineblockCertAsString, trustChainAsString);
            this.metadata();
            System.exit(0);
        }
        catch (Throwable t) {
            LOG.error("Exiting because of exception", t);
            System.exit(2);
        }
    }

    public void metadata() {
        LOG.info("Running tests for validating metadata of Engineblock");
        try {
            LOG.info("Validating IDP Proxy metadata...");
            this.engineblock.validateIdpProxyMetadata();
            LOG.info("Validating SP Proxy metadata...");
            this.engineblock.validateSpProxyMetadata();
            LOG.info("Validating IDPs metadata...");
            this.engineblock.validateIdpsMetadata();
            this.engineblock.destroy();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

