/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.monitoring;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Timer;
import nl.surfnet.coin.monitoring.TrustSSLProtocolSocketFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.BaseMetadataProvider;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataFilterChain;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.SchemaValidationFilter;
import org.opensaml.saml2.metadata.provider.SignatureValidationFilter;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.StaticCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.StaticKeyInfoCredentialResolver;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.signature.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engineblock {
    private static final Logger LOG = LoggerFactory.getLogger(Engineblock.class);
    private final String engineUrlBase;
    private final String engineblockCert;
    private final String trustChain;
    private Set<BaseMetadataProvider> metadataProviders = new HashSet<BaseMetadataProvider>();

    public Engineblock(String url, String engineblockCert, String trustChain) throws Exception {
        this.engineUrlBase = url;
        this.engineblockCert = engineblockCert;
        this.trustChain = trustChain;
        DefaultBootstrap.bootstrap();
        if (trustChain != null) {
            this.configureHttpClientSslTrust(trustChain);
        }
    }

    private void configureHttpClientSslTrust(String cert) throws IOException, GeneralSecurityException {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new TrustSSLProtocolSocketFactory(cert), 443));
    }

    public void validateIdpProxyMetadata() throws Exception {
        MetadataProvider metadataProvider = this.createMetadataProvider(this.engineUrlBase + "/authentication/idp/metadata");
        String correctEntityId = this.engineUrlBase + "/authentication/idp/metadata";
        String entityIdFromMetadata = ((EntityDescriptor)metadataProvider.getMetadata()).getEntityID();
        LOG.debug("Engine metadata has entity ID: {}", (Object)entityIdFromMetadata);
        Assert.assertEquals((Object)correctEntityId, (Object)entityIdFromMetadata);
        EntityDescriptor entityDescriptor = metadataProvider.getEntityDescriptor(entityIdFromMetadata);
        DateTime halfDayFromNow = new DateTime().plusHours(12);
        Assert.assertTrue((String)"validUntil of the metadata should be at least 12 hrs in future", (boolean)entityDescriptor.getValidUntil().isAfter((ReadableInstant)halfDayFromNow));
    }

    public void validateIdpsMetadata() throws Exception {
        this.createMetadataProvider(this.engineUrlBase + "/authentication/proxy/idps-metadata");
    }

    public void validateSpProxyMetadata() throws Exception {
        this.createMetadataProvider(this.engineUrlBase + "/authentication/sp/metadata");
    }

    private SignatureTrustEngine buildTrustEngine(String entityCertPEM, String x509certChain) throws CertificateException {
        BasicX509Credential ebCredential = new BasicX509Credential();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate entityCertificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(entityCertPEM.getBytes()));
        ebCredential.setPublicKey(entityCertificate.getPublicKey());
        ebCredential.setEntityCertificate(entityCertificate);
        if (x509certChain != null) {
            Collection<? extends Certificate> certs = cf.generateCertificates(new ByteArrayInputStream(x509certChain.getBytes()));
            ebCredential.setEntityCertificateChain(certs);
        }
        return new ExplicitKeySignatureTrustEngine((CredentialResolver)new StaticCredentialResolver((Credential)ebCredential), (KeyInfoCredentialResolver)new StaticKeyInfoCredentialResolver((Credential)ebCredential));
    }

    public void destroy() {
        for (BaseMetadataProvider prov : this.metadataProviders) {
            prov.destroy();
        }
    }

    public MetadataProvider createMetadataProvider(String url) throws MetadataProviderException, CertificateException {
        Timer backgroundTaskTimer = new Timer(true);
        HttpClient client = new HttpClient();
        HTTPMetadataProvider metadataProvider = new HTTPMetadataProvider(backgroundTaskTimer, client, url);
        metadataProvider.setRequireValidMetadata(true);
        metadataProvider.setParserPool((ParserPool)new BasicParserPool());
        MetadataFilterChain filterChain = new MetadataFilterChain();
        filterChain.setFilters(Arrays.asList(new SchemaValidationFilter(new String[]{"/schema__/sstc-saml-metadata-ui-v1.0.xsd"}), new SignatureValidationFilter(this.buildTrustEngine(this.engineblockCert, this.trustChain))));
        metadataProvider.setMetadataFilter((MetadataFilter)filterChain);
        metadataProvider.initialize();
        this.metadataProviders.add((BaseMetadataProvider)metadataProvider);
        return metadataProvider;
    }

    public void acceptConsentIfPresent(WebDriver driver) {
        try {
            WebElement button = driver.findElement(By.id((String)"accept_terms_button"));
            button.click();
        }
        catch (NoSuchElementException e) {
            LOG.debug("No consent screen, will skip without error.");
        }
    }

    public void chooseIdPByLabel(WebDriver driver, String label) {
        String xpathExpression = String.format("//span[normalize-space()='%s']", StringEscapeUtils.escapeXml((String)label));
        WebElement element = driver.findElement(By.xpath((String)xpathExpression));
        element.click();
    }
}

