/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.csa.model;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class JiraTask {
    private String key;
    private String serviceProvider;
    private String identityProvider;
    private String institution;
    private String body;
    private Status status;
    private Type issueType;

    private JiraTask() {
    }

    public String getServiceProvider() {
        return this.serviceProvider;
    }

    public String getIdentityProvider() {
        return this.identityProvider;
    }

    public String getInstitution() {
        return this.institution;
    }

    public Status getStatus() {
        return this.status;
    }

    public Type getIssueType() {
        return this.issueType;
    }

    public String getBody() {
        return this.body;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }

    public static class Builder {
        private String key = "";
        private String serviceProvider = "";
        private String identityProvider = "";
        private String institution = "";
        private Status status = Status.OPEN;
        private Type issueType = Type.QUESTION;
        private String body = "";

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder serviceProvider(String name) {
            this.serviceProvider = name;
            return this;
        }

        public Builder identityProvider(String name) {
            this.identityProvider = name;
            return this;
        }

        public Builder institution(String name) {
            this.institution = name;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder issueType(Type issueType) {
            this.issueType = issueType;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public JiraTask build() {
            JiraTask task = new JiraTask();
            task.key = this.key;
            task.serviceProvider = this.serviceProvider;
            task.identityProvider = this.identityProvider;
            task.institution = this.institution;
            task.status = this.status;
            task.issueType = this.issueType;
            task.body = this.body;
            return task;
        }
    }

    public static enum Type {
        LINKREQUEST,
        UNLINKREQUEST,
        QUESTION;

    }

    public static enum Status {
        OPEN,
        CLOSED;

    }

    public static enum Action {
        REOPEN,
        CLOSE;

    }
}

