/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.csa.model;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Statistics {
    private int totalQuestions = 0;
    private int totalLinkRequests = 0;
    private int totalUnlinkRequests = 0;
    private Map<String, Integer> institutionQuestions = new HashMap<String, Integer>();
    private Map<String, Integer> institutionLinkRequests = new HashMap<String, Integer>();
    private Map<String, Integer> institutionUnlinkRequests = new HashMap<String, Integer>();

    public Statistics() {
    }

    public Statistics(int totalQuestions, int totalLinkRequests, int totalUnlinkRequests) {
        this.totalQuestions = totalQuestions;
        this.totalLinkRequests = totalLinkRequests;
        this.totalUnlinkRequests = totalUnlinkRequests;
    }

    public int getTotalQuestions() {
        return this.totalQuestions;
    }

    public int getTotalLinkRequests() {
        return this.totalLinkRequests;
    }

    public int getTotalUnlinkRequests() {
        return this.totalUnlinkRequests;
    }

    public Map<String, Integer> getInstitutionQuestions() {
        return this.institutionQuestions;
    }

    public Map<String, Integer> getInstitutionLinkRequests() {
        return this.institutionLinkRequests;
    }

    public Map<String, Integer> getInstitutionUnlinkRequests() {
        return this.institutionUnlinkRequests;
    }

    public void countTotalQuestions() {
        ++this.totalQuestions;
    }

    public void countTotalLinkRequests() {
        ++this.totalLinkRequests;
    }

    public void countTotalUnlinkRequests() {
        ++this.totalUnlinkRequests;
    }

    public void countInstitutionQuestion(String institution) {
        this.addCounterInInstitutionMap(this.institutionQuestions, institution);
    }

    public void countInstitutionLinkRequest(String institution) {
        this.addCounterInInstitutionMap(this.institutionLinkRequests, institution);
    }

    public void countInstitutionUnlinkRequest(String institution) {
        this.addCounterInInstitutionMap(this.institutionUnlinkRequests, institution);
    }

    private void addCounterInInstitutionMap(Map<String, Integer> institutionMap, String institution) {
        if (null == institutionMap.get(institution)) {
            institutionMap.put(institution, new Integer(1));
        } else {
            int count = institutionMap.get(institution);
            institutionMap.put(institution, ++count);
        }
    }
}

