/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.csa.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nl.surfnet.coin.csa.model.Category;
import nl.surfnet.coin.csa.model.CategoryValue;
import nl.surfnet.coin.csa.model.CrmArticle;
import nl.surfnet.coin.csa.model.License;
import nl.surfnet.coin.janus.domain.ARP;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Service
implements Comparable<Service> {
    private long id;
    private String name;
    private String description;
    private String logoUrl;
    private String websiteUrl;
    private String appUrl;
    private String serviceUrl;
    private String crmUrl;
    private String detailLogoUrl;
    private String supportUrl;
    private String eulaUrl;
    private List<String> screenshotUrls;
    private String supportMail;
    private String enduserDescription;
    private String institutionDescription;
    private Date lastLoginDate;
    private boolean connected;
    private boolean hasCrmLink;
    private CrmArticle crmArticle;
    private License license;
    private List<Category> categories;
    private String spEntityId;
    private ARP arp;
    private boolean availableForEndUser;
    private boolean idpVisibleOnly;

    public Service() {
    }

    public Service(long id, String name, String logoUrl, String websiteUrl, boolean hasCrmLink, String crmUrl, String spEntityId) {
        this.id = id;
        this.name = name;
        this.logoUrl = logoUrl;
        this.websiteUrl = websiteUrl;
        this.hasCrmLink = hasCrmLink;
        this.crmUrl = crmUrl;
        this.spEntityId = spEntityId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    public void setWebsiteUrl(String websiteUrl) {
        this.websiteUrl = websiteUrl;
    }

    public boolean isHasCrmLink() {
        return this.hasCrmLink;
    }

    public void setHasCrmLink(boolean hasCrmLink) {
        this.hasCrmLink = hasCrmLink;
    }

    public String getCrmUrl() {
        return this.crmUrl;
    }

    public void setCrmUrl(String crmUrl) {
        this.crmUrl = crmUrl;
    }

    @Override
    public int compareTo(Service other) {
        if (other == null) {
            return 1;
        }
        String otherName = other.getName();
        if (this.name == null && otherName == null) {
            return -1;
        }
        if (this.name == null) {
            return -1;
        }
        if (otherName == null) {
            return 1;
        }
        return this.name.compareTo(otherName);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    @JsonIgnore
    public String getSearchFacetValues() {
        ArrayList<String> values = new ArrayList<String>();
        if (this.categories != null && !this.categories.isEmpty()) {
            for (Category c : this.categories) {
                for (CategoryValue v : c.getValues()) {
                    values.add(v.getSearchValue());
                }
            }
        }
        return StringUtils.join(values, (String)" ");
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public String getSpEntityId() {
        return this.spEntityId;
    }

    public void setSpEntityId(String spEntityId) {
        this.spEntityId = spEntityId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getDetailLogoUrl() {
        return this.detailLogoUrl;
    }

    public void setDetailLogoUrl(String detailLogoUrl) {
        this.detailLogoUrl = detailLogoUrl;
    }

    public CrmArticle getCrmArticle() {
        return this.crmArticle;
    }

    public void setCrmArticle(CrmArticle crmArticle) {
        this.crmArticle = crmArticle;
    }

    public String getSupportUrl() {
        return this.supportUrl;
    }

    public void setSupportUrl(String supportUrl) {
        this.supportUrl = supportUrl;
    }

    public String getEulaUrl() {
        return this.eulaUrl;
    }

    public void setEulaUrl(String eulaUrl) {
        this.eulaUrl = eulaUrl;
    }

    public List<String> getScreenshotUrls() {
        return this.screenshotUrls;
    }

    public void setScreenshotUrls(List<String> screenshotUrls) {
        this.screenshotUrls = screenshotUrls;
    }

    public String getSupportMail() {
        return this.supportMail;
    }

    public void setSupportMail(String supportMail) {
        this.supportMail = supportMail;
    }

    public String getEnduserDescription() {
        return this.enduserDescription;
    }

    public void setEnduserDescription(String enduserDescription) {
        this.enduserDescription = enduserDescription;
    }

    public String getInstitutionDescription() {
        return this.institutionDescription;
    }

    public void setInstitutionDescription(String institutionDescription) {
        this.institutionDescription = institutionDescription;
    }

    public ARP getArp() {
        return this.arp;
    }

    public void setArp(ARP arp) {
        this.arp = arp;
    }

    public void restoreCategoryReferences() {
        if (this.categories == null) {
            return;
        }
        for (Category category : this.categories) {
            List<CategoryValue> values = category.getValues();
            for (CategoryValue value : values) {
                value.setCategory(category);
            }
        }
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public boolean isAvailableForEndUser() {
        return this.availableForEndUser;
    }

    public void setAvailableForEndUser(boolean availableForEndUser) {
        this.availableForEndUser = availableForEndUser;
    }

    public boolean isIdpVisibleOnly() {
        return this.idpVisibleOnly;
    }

    public void setIdpVisibleOnly(boolean idpVisibleOnly) {
        this.idpVisibleOnly = idpVisibleOnly;
    }
}

