/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.csa;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import nl.surfnet.coin.csa.Csa;
import nl.surfnet.coin.csa.model.Action;
import nl.surfnet.coin.csa.model.Category;
import nl.surfnet.coin.csa.model.CategoryValue;
import nl.surfnet.coin.csa.model.InstitutionIdentityProvider;
import nl.surfnet.coin.csa.model.Service;
import nl.surfnet.coin.csa.model.Taxonomy;
import nl.surfnet.coin.oauth.OauthClient;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsaClient
implements Csa {
    private static final Logger LOG = LoggerFactory.getLogger(CsaClient.class);
    private OauthClient oauthClient;
    private ObjectMapper objectMapper = new ObjectMapper().enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    private String csaBaseLocation;

    public CsaClient() {
    }

    public CsaClient(String csaBaseLocation) {
        this.csaBaseLocation = csaBaseLocation;
    }

    @Override
    public List<Service> getPublicServices() {
        return this.restoreCategoryReferences((List)this.oauthClient.exchange(this.csaBaseLocation + "/api/public/services.json", Service[].class));
    }

    @Override
    public List<Service> getProtectedServices() {
        return this.restoreCategoryReferences((List)this.oauthClient.exchange(this.csaBaseLocation + "/api/protected/services.json", Service[].class));
    }

    @Override
    public List<Service> getServicesForIdp(String idpEntityId) {
        String url = this.csaBaseLocation + "/api/protected/idp/services.json?idpEntityId={idpEntityId}";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("idpEntityId", idpEntityId);
        return this.restoreCategoryReferences((List)this.oauthClient.exchange(url, variables, Service[].class));
    }

    @Override
    public Service getServiceForIdp(String idpEntityId, long serviceId) {
        String location = this.csaBaseLocation + "/api/protected/services/{serviceId}.json?idpEntityId={idpEntityId}";
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("serviceId", serviceId);
        variables.put("idpEntityId", idpEntityId);
        Service service = (Service)this.oauthClient.exchange(location, variables, Service.class);
        service.restoreCategoryReferences();
        return service;
    }

    @Override
    public Service getServiceForIdp(String idpEntityId, String spEntityId) {
        String url = this.csaBaseLocation + "/api/protected/service.json?idpEntityId={idpEntityId}&spEntityId={spEntityId}";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("idpEntityId", idpEntityId);
        variables.put("spEntityId", spEntityId);
        Service service = (Service)this.oauthClient.exchange(url, variables, Service.class);
        service.restoreCategoryReferences();
        return service;
    }

    @Override
    public Taxonomy getTaxonomy() {
        Taxonomy taxonomy = (Taxonomy)this.oauthClient.exchange(this.csaBaseLocation + "/api/public/taxonomy.json", Taxonomy.class);
        List<Category> categories = taxonomy.getCategories();
        for (Category category : categories) {
            List<CategoryValue> values = category.getValues();
            for (CategoryValue value : values) {
                value.setCategory(category);
            }
        }
        return taxonomy;
    }

    @Override
    public List<Action> getJiraActions(String idpEntityId) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("idpEntityId", idpEntityId);
        return (List)this.oauthClient.exchange(this.csaBaseLocation + "/api/protected/actions.json?idpEntityId={idpEntityId}", variables, Action[].class);
    }

    @Override
    public Action createAction(Action action) {
        return (Action)this.oauthClient.exchange(this.csaBaseLocation + "/api/protected/action.json", action, Action.class);
    }

    @Override
    public List<InstitutionIdentityProvider> getInstitutionIdentityProviders(String identityProviderId) {
        return (List)this.oauthClient.exchange(this.csaBaseLocation + "/api/protected/identityproviders.json?identityProviderId={identityProviderId}", Collections.singletonMap("identityProviderId", identityProviderId), InstitutionIdentityProvider[].class);
    }

    @Override
    public List<InstitutionIdentityProvider> getAllInstitutionIdentityProviders() {
        return (List)this.oauthClient.exchange(this.csaBaseLocation + "/api/protected/all-identityproviders.json", InstitutionIdentityProvider[].class);
    }

    @Override
    public void setCsaBaseLocation(String csaBaseLocation) {
        this.csaBaseLocation = csaBaseLocation;
    }

    @Override
    public void setOauthClient(OauthClient oauthClient) {
        this.oauthClient = oauthClient;
    }

    private List<Service> restoreCategoryReferences(List<Service> services) {
        for (Service service : services) {
            service.restoreCategoryReferences();
        }
        return services;
    }
}

