/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.oauth;

import java.net.URI;
import java.util.Map;
import nl.surfnet.coin.oauth.OauthClient;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;

public class ClientCredentialsClient
extends OauthClient {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCredentialsClient.class);
    private String clientKey;
    private String clientSecret;
    private String oauthAuthorizationUrl;

    @Override
    public String getAccessToken() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])(this.clientKey + ":" + this.clientSecret).getBytes())));
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity requestEntity = new HttpEntity((Object)"grant_type=client_credentials", (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(URI.create(this.oauthAuthorizationUrl), HttpMethod.POST, requestEntity, Map.class);
            if (response.getStatusCode() != HttpStatus.OK) {
                LOG.error("Received HttpStatus {} when trying to obtain AccessToken", (Object)response.getStatusCode());
                return null;
            }
            Map map = (Map)response.getBody();
            return (String)map.get("access_token");
        }
        catch (RestClientException e) {
            LOG.error("Error trying to obtain AccessToken", (Throwable)e);
            return null;
        }
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setOauthAuthorizationUrl(String oauthAuthorizationUrl) {
        this.oauthAuthorizationUrl = oauthAuthorizationUrl;
    }
}

