/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.oauth;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

public abstract class OauthClient {
    private ObjectMapper objectMapper = new ObjectMapper().enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    private static final Logger LOG = LoggerFactory.getLogger(OauthClient.class);
    protected RestTemplate restTemplate = new RestTemplate();
    private String accessToken;

    public <T> T exchange(String url, Class clazz) {
        return this.exchange(url, null, clazz);
    }

    public <T> T exchange(String url, Object bodyJson, Class clazz) {
        return this.exchange(url, null, bodyJson, clazz);
    }

    public <T> T exchange(String url, Map<String, ?> variables, Class clazz) {
        return this.exchange(url, variables, null, clazz);
    }

    public <T> T exchange(String url, Map<String, ?> variables, Object postObject, Class clazz) {
        return this.doExchange(url, variables, postObject, clazz, true);
    }

    protected <T> T doExchange(String url, Map<String, ?> variables, Object bodyJson, Class clazz, boolean retry) {
        ResponseEntity response;
        HttpMethod method;
        HttpEntity requestEntity;
        HttpHeaders headers = new HttpHeaders();
        if (this.accessToken == null) {
            this.accessToken = this.getAccessToken();
        }
        headers.add("Authorization", "bearer " + this.accessToken);
        if (bodyJson != null) {
            requestEntity = new HttpEntity(bodyJson, (MultiValueMap)headers);
            method = HttpMethod.POST;
        } else {
            requestEntity = new HttpEntity((MultiValueMap)headers);
            method = HttpMethod.GET;
        }
        String fullUrl = url;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Will send {}-request to {}, with parameters {} and body: {}", new Object[]{method.name(), fullUrl, variables, bodyJson});
        }
        long start = System.currentTimeMillis();
        try {
            response = CollectionUtils.isEmpty(variables) ? this.restTemplate.exchange(URI.create(fullUrl), method, requestEntity, clazz) : this.restTemplate.exchange(fullUrl, method, requestEntity, clazz, variables);
        }
        catch (HttpClientErrorException clientException) {
            if (clientException.getStatusCode() == HttpStatus.FORBIDDEN && retry) {
                LOG.info("Got a 'forbidden' response. Will retry with a new access token. HTTP status: {}", (Object)clientException.getMessage());
                this.accessToken = null;
                return this.doExchange(url, variables, bodyJson, clazz, false);
            }
            LOG.info("Error during request to Resource Server {}. Response body: {}", (Object)url, (Object)clientException.getResponseBodyAsString());
            throw clientException;
        }
        catch (HttpServerErrorException serverException) {
            LOG.info("Error during request to Resource Server {}. Response body: {}", (Object)url, (Object)serverException.getResponseBodyAsString());
            throw serverException;
        }
        Object body = response.getBody();
        if (LOG.isTraceEnabled()) {
            try {
                LOG.trace("Response (took {} milliseconds) : {}", (Object)(System.currentTimeMillis() - start), (Object)this.objectMapper.writeValueAsString(body));
            }
            catch (IOException e) {
                LOG.info("Could not serialize response object for logging: {}", (Object)e.getMessage());
            }
        }
        if (clazz.isArray()) {
            return (T)this.getListResult((Object[])body);
        }
        return (T)body;
    }

    protected <T> T getListResult(T[] body) {
        T[] arr;
        ArrayList<T> result = new ArrayList<T>();
        for (T t : arr = body) {
            result.add(t);
        }
        return (T)result;
    }

    protected abstract String getAccessToken();
}

